/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.springsupport.transaction;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.QueueingException;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.springsupport.transaction.TransactionalJobStatus;
import jp.terasoluna.fw.batch.standard.QueueProcessor;

public class TransactionalQueueProcessor
extends QueueProcessor {
    public void process(WorkQueue workQueue, JobStatus jobStatus) {
        TransactionalJobStatus transactionalJobStatus = (TransactionalJobStatus)jobStatus;
        transactionalJobStatus.beginTransaction();
        try {
            super.process(workQueue, jobStatus);
        }
        catch (QueueingException e) {
            if (jobStatus.getJobState() == JobStatus.STATE.SUSPENDING) {
                transactionalJobStatus.rollback();
                return;
            }
            throw e;
        }
        if (jobStatus.isExecuting() || jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY || jobStatus.isShutdownGraceful()) {
            transactionalJobStatus.commit();
        } else {
            transactionalJobStatus.rollback();
        }
        if (jobStatus.isShutdownGraceful()) {
            jobStatus.suspend();
        }
    }
}

