/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.restart;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.SupportProcessor;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.restart.JobRestartTableHandler;

public class RestartPreProcessor
implements SupportProcessor {
    private JobRestartTableHandler jobRestartTableHandler = null;
    private SupportProcessor preProcessor = null;
    private boolean parentManager = false;

    public void process(JobContext jobContext, JobStatus jobStatus) {
        if (jobStatus.getJobState() == JobStatus.STATE.RESTARTED) {
            return;
        }
        this.preProcessor.process(jobContext, jobStatus);
        if (!jobStatus.isContinue()) {
            return;
        }
        if (this.parentManager) {
            this.jobRestartTableHandler.registerRestartPoint(jobContext, jobStatus);
        }
    }

    public void setJobRestartTableHandler(JobRestartTableHandler jobRestartTableHandler) {
        this.jobRestartTableHandler = jobRestartTableHandler;
    }

    public boolean canSkip() {
        return false;
    }

    public void setPreProcessor(SupportProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public void setParentManager(boolean parentManager) {
        this.parentManager = parentManager;
    }
}

