/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.validation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;
import jp.terasoluna.fw.beans.IndexedBeanWrapper;
import jp.terasoluna.fw.beans.JXPathIndexedBeanWrapperImpl;
import jp.terasoluna.fw.util.BeanUtil;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.util.PropertyAccessException;
import jp.terasoluna.fw.validation.MultiFieldValidator;
import jp.terasoluna.fw.validation.ValidationErrors;
import jp.terasoluna.fw.validation.ValidationUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.util.ValidatorUtils;

public class FieldChecks {
    private static Log log = LogFactory.getLog(FieldChecks.class);

    public boolean validateRequired(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (GenericValidator.isBlankOrNull((String)value)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateMask(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        String mask = field.getVarValue("mask");
        if (StringUtils.isEmpty((String)mask)) {
            log.error((Object)"var[mask] must be specified.");
            throw new ValidatorException("var[mask] must be specified.");
        }
        if (!GenericValidator.matchRegexp((String)value, (String)mask)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateByte(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (GenericTypeValidator.formatByte((String)value) == null) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateShort(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (GenericTypeValidator.formatShort((String)value) == null) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateInteger(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (GenericTypeValidator.formatInt((String)value) == null) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateLong(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (GenericTypeValidator.formatLong((String)value) == null) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateFloat(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (GenericTypeValidator.formatFloat((String)value) == null) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateDouble(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (GenericTypeValidator.formatDouble((String)value) == null) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateDate(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        String datePattern = field.getVarValue("datePattern");
        String datePatternStrict = field.getVarValue("datePatternStrict");
        Date result = null;
        try {
            result = ValidationUtil.toDate(value, datePattern, datePatternStrict);
        }
        catch (IllegalArgumentException e) {
            String message = "Mistake on validation definition file. - datePattern or datePatternStrict is invalid. You'll have to check it over. ";
            log.error((Object)message, (Throwable)e);
            throw new ValidatorException(message);
        }
        if (result == null) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateIntRange(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        int intValue = 0;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        String strMin = field.getVarValue("intRangeMin");
        int min = Integer.MIN_VALUE;
        if (!GenericValidator.isBlankOrNull((String)strMin)) {
            try {
                min = Integer.parseInt(strMin);
            }
            catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. - intRangeMin is not number. You'll have to check it over. ";
                log.error((Object)message, (Throwable)e);
                throw new ValidatorException(message);
            }
        }
        String strMax = field.getVarValue("intRangeMax");
        int max = Integer.MAX_VALUE;
        if (!GenericValidator.isBlankOrNull((String)strMax)) {
            try {
                max = Integer.parseInt(strMax);
            }
            catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. - intRangeMax is not number. You'll have to check it over. ";
                log.error((Object)message, (Throwable)e);
                throw new ValidatorException(message);
            }
        }
        if (!GenericValidator.isInRange((int)intValue, (int)min, (int)max)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateDoubleRange(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        double dblValue = 0.0;
        try {
            dblValue = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        String strMin = field.getVarValue("doubleRangeMin");
        double min = Double.MIN_VALUE;
        if (!GenericValidator.isBlankOrNull((String)strMin)) {
            try {
                min = Double.parseDouble(strMin);
            }
            catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. - doubleRangeMin is not number. You'll have to check it over. ";
                log.error((Object)message, (Throwable)e);
                throw new ValidatorException(message);
            }
        }
        String strMax = field.getVarValue("doubleRangeMax");
        double max = Double.MAX_VALUE;
        if (!GenericValidator.isBlankOrNull((String)strMax)) {
            try {
                max = Double.parseDouble(strMax);
            }
            catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. - doubleRangeMax is not number. You'll have to check it over. ";
                log.error((Object)message, (Throwable)e);
                throw new ValidatorException(message);
            }
        }
        if (!GenericValidator.isInRange((double)dblValue, (double)min, (double)max)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateFloatRange(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        float floatValue = 0.0f;
        try {
            floatValue = Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        String strMin = field.getVarValue("floatRangeMin");
        float min = Float.MIN_VALUE;
        if (!GenericValidator.isBlankOrNull((String)strMin)) {
            try {
                min = Float.parseFloat(strMin);
            }
            catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. - floatRangeMin is not number. You'll have to check it over. ";
                log.error((Object)message, (Throwable)e);
                throw new ValidatorException(message);
            }
        }
        String strMax = field.getVarValue("floatRangeMax");
        float max = Float.MAX_VALUE;
        if (!GenericValidator.isBlankOrNull((String)strMax)) {
            try {
                max = Float.parseFloat(strMax);
            }
            catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. - floatRangeMax is not number. You'll have to check it over. ";
                log.error((Object)message, (Throwable)e);
                throw new ValidatorException(message);
            }
        }
        if (!GenericValidator.isInRange((float)floatValue, (float)min, (float)max)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateMaxLength(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        int max = 0;
        try {
            max = Integer.parseInt(field.getVarValue("maxlength"));
        }
        catch (NumberFormatException e) {
            String message = "Mistake on validation definition file. - maxlength is not number. You'll have to check it over. ";
            log.error((Object)message, (Throwable)e);
            throw new ValidatorException(message);
        }
        if (!GenericValidator.maxLength((String)value, (int)max)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateMinLength(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        int min = 0;
        try {
            min = Integer.parseInt(field.getVarValue("minlength"));
        }
        catch (NumberFormatException e) {
            String message = "Mistake on validation definition file. - minlength is not number. You'll have to check it over. ";
            log.error((Object)message, (Throwable)e);
            throw new ValidatorException(message);
        }
        if (!GenericValidator.minLength((String)value, (int)min)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateAlphaNumericString(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (!ValidationUtil.isAlphaNumericString(value)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateCapAlphaNumericString(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (!ValidationUtil.isUpperAlphaNumericString(value)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateNumber(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        boolean isAccordedScale;
        boolean isAccordedInteger;
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (!ValidationUtil.isHankakuString(value)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        BigDecimal number = null;
        try {
            number = new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        int integerLength = Integer.MAX_VALUE;
        String integerLengthStr = field.getVarValue("integerLength");
        if (!GenericValidator.isBlankOrNull((String)integerLengthStr)) {
            try {
                integerLength = Integer.parseInt(integerLengthStr);
            }
            catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. - integerLength is not number. You'll have to check it over. ";
                log.error((Object)message, (Throwable)e);
                throw new ValidatorException(message);
            }
        }
        int scaleLength = Integer.MAX_VALUE;
        String scaleStr = field.getVarValue("scale");
        if (!GenericValidator.isBlankOrNull((String)scaleStr)) {
            try {
                scaleLength = Integer.parseInt(scaleStr);
            }
            catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. - scale is not number. You'll have to check it over. ";
                log.error((Object)message, (Throwable)e);
                throw new ValidatorException(message);
            }
        }
        if (!ValidationUtil.isNumber(number, integerLength, isAccordedInteger = "true".equals(field.getVarValue("isAccordedInteger")), scaleLength, isAccordedScale = "true".equals(field.getVarValue("isAccordedScale")))) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateHankakuKanaString(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (!ValidationUtil.isHankakuKanaString(value)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateHankakuString(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (!ValidationUtil.isHankakuString(value)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateZenkakuString(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (!ValidationUtil.isZenkakuString(value)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateZenkakuKanaString(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (!ValidationUtil.isZenkakuKanaString(value)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateProhibited(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        String prohibitedStr = field.getVarValue("chars");
        if (StringUtils.isEmpty((String)prohibitedStr)) {
            log.error((Object)"var[chars] must be specified.");
            throw new ValidatorException("var[chars] must be specified.");
        }
        if (!ValidationUtil.hasNotProhibitedChar(value, prohibitedStr)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateNumericString(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        if (!ValidationUtil.isNumericString(value)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateStringLength(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        int length = Integer.MAX_VALUE;
        String lengthStr = field.getVarValue("stringLength");
        try {
            length = Integer.valueOf(lengthStr);
        }
        catch (NumberFormatException e) {
            String message = "Mistake on validation definition file. - stringLength is not number. You'll have to check it over. ";
            log.error((Object)message, (Throwable)e);
            throw new ValidatorException(message);
        }
        if (value.length() != length) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateArrayRange(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        if (bean == null) {
            String message = "target of validateArrayRange must be not null.";
            log.error((Object)message);
            throw new ValidatorException(message);
        }
        try {
            Class type = BeanUtil.getBeanPropertyType((Object)bean, (String)field.getProperty());
            if (type == null) {
                String message = "Cannot get property type[" + bean.getClass().getName() + "." + field.getProperty() + "]";
                log.error((Object)message);
                throw new ValidatorException(message);
            }
            if (!type.isArray() && !Collection.class.isAssignableFrom(type)) {
                String message = "property [" + bean.getClass().getName() + "." + field.getProperty() + "] must be instance of Array or Collection.";
                log.error((Object)message);
                throw new ValidatorException(message);
            }
        }
        catch (PropertyAccessException e) {
            String message = "Cannot get property type[" + bean.getClass().getName() + "." + field.getProperty() + "]";
            log.error((Object)message, (Throwable)e);
            throw new ValidatorException(message);
        }
        Object obj = null;
        try {
            obj = BeanUtil.getBeanProperty((Object)bean, (String)field.getProperty());
        }
        catch (PropertyAccessException e) {
            String message = "Cannot get property [" + bean.getClass().getName() + "." + field.getProperty() + "]";
            log.error((Object)message, (Throwable)e);
            throw new ValidatorException(message);
        }
        int min = 0;
        String minStr = field.getVarValue("minArrayLength");
        if (!GenericValidator.isBlankOrNull((String)minStr)) {
            try {
                min = Integer.parseInt(minStr);
            }
            catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. - minArrayLength is not number. You'll have to check it over. ";
                log.error((Object)message, (Throwable)e);
                throw new ValidatorException(message);
            }
        }
        int max = Integer.MAX_VALUE;
        String maxStr = field.getVarValue("maxArrayLength");
        if (!GenericValidator.isBlankOrNull((String)maxStr)) {
            try {
                max = Integer.parseInt(maxStr);
            }
            catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. - maxArrayLength is not number. You'll have to check it over. ";
                log.error((Object)message, (Throwable)e);
                throw new ValidatorException(message);
            }
        }
        try {
            if (!ValidationUtil.isArrayInRange(obj, min, max)) {
                this.rejectValue(errors, field, va, bean);
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage());
            throw new ValidatorException(e.getMessage());
        }
        return true;
    }

    public boolean validateUrl(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        String schemesVar;
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        boolean allowallschemes = "true".equals(field.getVarValue("allowallschemes"));
        boolean allow2slashes = "true".equals(field.getVarValue("allow2slashes"));
        boolean nofragments = "true".equals(field.getVarValue("nofragments"));
        String string = schemesVar = allowallschemes ? null : field.getVarValue("schemes");
        if (!ValidationUtil.isUrl(value, allowallschemes, allow2slashes, nofragments, schemesVar)) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    public boolean validateByteRange(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        String encoding = field.getVarValue("encoding");
        int min = 0;
        String minStr = field.getVarValue("minByteLength");
        if (!GenericValidator.isBlankOrNull((String)minStr)) {
            try {
                min = Integer.parseInt(minStr);
            }
            catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. - minByteLength is not number. You'll have to check it over. ";
                log.error((Object)message, (Throwable)e);
                throw new ValidatorException(message);
            }
        }
        int max = Integer.MAX_VALUE;
        String maxStr = field.getVarValue("maxByteLength");
        if (!GenericValidator.isBlankOrNull((String)maxStr)) {
            try {
                max = Integer.parseInt(maxStr);
            }
            catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. - maxByteLength is not number. You'll have to check it over. ";
                log.error((Object)message, (Throwable)e);
                throw new ValidatorException(message);
            }
        }
        try {
            if (!ValidationUtil.isByteInRange(value, encoding, min, max)) {
                this.rejectValue(errors, field, va, bean);
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("encoding[" + encoding + "] is not supported."));
            throw new ValidatorException("encoding[" + encoding + "] is not supported.");
        }
        return true;
    }

    public boolean validateDateRange(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        String value = this.extractValue(bean, field);
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        String datePattern = field.getVarValue("datePattern");
        String datePatternStrict = field.getVarValue("datePatternStrict");
        String startDateStr = field.getVarValue("startDate");
        String endDateStr = field.getVarValue("endDate");
        try {
            if (!ValidationUtil.isDateInRange(value, startDateStr, endDateStr, datePattern, datePatternStrict)) {
                this.rejectValue(errors, field, va, bean);
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage());
            throw new ValidatorException(e.getMessage());
        }
        return true;
    }

    public boolean validateArraysIndex(Object bean, ValidatorAction va, Field field, ValidationErrors errors) throws ValidatorException {
        if (bean == null) {
            log.error((Object)"validation target bean is null.");
            throw new ValidatorException("validation target bean is null.");
        }
        Class[] paramClass = null;
        Method method = null;
        try {
            paramClass = this.getParamClass(va);
            if (paramClass == null || paramClass.length == 0) {
                String message = "Mistake on validation rule file. - Can not get argument class. You'll have to check it over. ";
                log.error((Object)message);
                throw new ValidatorException(message);
            }
            method = this.getMethod(va, paramClass);
            if (method == null) {
                String message = "Mistake on validation rule file. - Can not get validateMethod. You'll have to check it over. ";
                log.error((Object)message);
                throw new ValidatorException(message);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidatorException(e.getMessage());
        }
        try {
            Object[] argParams = new Object[paramClass.length];
            argParams[0] = bean;
            argParams[1] = va;
            argParams[3] = errors;
            IndexedBeanWrapper bw = this.getIndexedBeanWrapper(bean);
            Map propertyMap = bw.getIndexedPropertyValues(field.getKey());
            boolean isValid = true;
            for (String key : propertyMap.keySet()) {
                Field indexedField = (Field)field.clone();
                indexedField.setKey(key);
                indexedField.setProperty(key);
                argParams[2] = indexedField;
                boolean bool = (Boolean)method.invoke((Object)this, argParams);
                if (bool) continue;
                isValid = false;
            }
            return isValid;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ValidatorException) {
                throw (ValidatorException)t;
            }
            log.error((Object)t.getMessage(), t);
            throw new ValidatorException(t.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidatorException(e.getMessage());
        }
    }

    protected IndexedBeanWrapper getIndexedBeanWrapper(Object bean) {
        return new JXPathIndexedBeanWrapperImpl(bean);
    }

    protected Class[] getParamClass(ValidatorAction va) {
        StringTokenizer st = new StringTokenizer(va.getMethodParams(), ",");
        Class[] paramClass = new Class[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            try {
                String key = st.nextToken().trim();
                paramClass[i] = ClassUtils.getClass((String)key);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            ++i;
        }
        return paramClass;
    }

    protected Method getMethod(ValidatorAction va, Class[] paramClass) {
        String methodNameSource = va.getName();
        if (methodNameSource == null || "".equals(methodNameSource)) {
            return null;
        }
        char[] chars = methodNameSource.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        String validate = "validate" + new String(chars);
        String methodName = validate.substring(0, validate.length() - "Array".length());
        Method method = null;
        try {
            method = FieldChecks.class.getMethod(methodName, paramClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return method;
    }

    public boolean validateMultiField(Object bean, ValidatorAction va, Field field, ValidationErrors errors) {
        if (bean == null) {
            log.error((Object)"bean is null.");
            return true;
        }
        Object value = null;
        if (bean instanceof String) {
            value = bean;
        } else {
            try {
                value = PropertyUtils.getProperty((Object)bean, (String)field.getProperty());
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        String multiFieldValidatorClass = field.getVarValue("multiFieldValidator");
        if (multiFieldValidatorClass == null || "".equals(multiFieldValidatorClass)) {
            log.error((Object)"var value[multiFieldValidator] is required.");
            throw new IllegalArgumentException("var value[multiFieldValidator] is required.");
        }
        MultiFieldValidator mfv = null;
        try {
            mfv = (MultiFieldValidator)ClassUtil.create((String)multiFieldValidatorClass);
        }
        catch (ClassLoadException e) {
            log.error((Object)"var value[multiFieldValidator] is invalid.", (Throwable)e);
            throw new IllegalArgumentException("var value[multiFieldValidator] is invalid.", e);
        }
        catch (ClassCastException e) {
            log.error((Object)"var value[multiFieldValidator] is invalid.", (Throwable)e);
            throw new IllegalArgumentException("var value[multiFieldValidator] is invalid.", e);
        }
        String fields = field.getVarValue("fields");
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (fields != null) {
            StringTokenizer st = new StringTokenizer(fields, ",");
            while (st.hasMoreTokens()) {
                String f = st.nextToken();
                f = f.trim();
                try {
                    valueList.add(PropertyUtils.getProperty((Object)bean, (String)f));
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("dependent fields:" + valueList));
        }
        Object[] values = new Object[valueList.size()];
        valueList.toArray(values);
        boolean result = mfv.validate(value, values);
        if (!result) {
            this.rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    protected String extractValue(Object bean, Field field) {
        String value = null;
        if (bean == null) {
            return null;
        }
        value = bean instanceof String ? (String)bean : (bean instanceof Number || bean instanceof Boolean || bean instanceof Character ? bean.toString() : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty()));
        return value;
    }

    protected void rejectValue(ValidationErrors errors, Field field, ValidatorAction va, Object bean) {
        errors.addError(bean, field, va);
    }
}

