/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.dao;

import java.util.List;
import java.util.Map;

/**
 * QueryDAOC^tF[XB
 * 
 * QƌnSQLs邽߂DAOC^tF[XłB
 *
 */
public interface QueryDAO {

    /**
     * SQL̎sʂw肳ꂽ^ɂĕԋpB
     * 
     * @param <E> ԋpľ^
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param clazz ԋpl̃NX
     * @return SQL̎s
     */
    <E> E executeForObject(String sqlID, Object bindParams, Class clazz);

    /**
     * SQL̎sʂMapɊi[ĕԋpB
     * 
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @return SQL̎s
     */
    Map<String, Object> executeForMap(String sqlID, Object bindParams);

    /**
     * SQL̎sʂw肳ꂽ^̔zɂĕԋpB
     * 
     * @param <E> ԋpľ^
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param clazz ԋpl̃NX
     * @return SQL̎s
     */
    <E> E[] executeForObjectArray(String sqlID,
            Object bindParams, Class clazz);

    /**
     * SQL̎sʂMap̔zɊi[ĕԋpB
     * 
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @return SQL̎s
     */
    Map<String, Object>[] executeForMapArray(String sqlID,
            Object bindParams);

    /**
     * SQL̎sʂw肳ꂽCfbNXw肳ꂽsA
     * w肳ꂽ^̔zɂĕԋpB
     * 
     * @param <E> ԋpľ^
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param clazz ԋpl̃NX
     * @param beginIndex 擾JnCfbNX
     * @param maxCount 擾錏
     * @return SQL̎s
     */
    <E> E[] executeForObjectArray(String sqlID,
            Object bindParams, Class clazz, int beginIndex, int maxCount);

    /**
     * SQL̎sʂw肳ꂽCfbNXw肳ꂽsA
     * Map̔zɂĕԋpB
     * 
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param beginIndex 擾JnCfbNX
     * @param maxCount 擾錏
     * @return SQL̎s
     */
    Map<String, Object>[] executeForMapArray(String sqlID,
            Object bindParams, int beginIndex, int maxCount);

    /**
     * SQL̎sʂw肳ꂽ^ListŕԋpB
     * 
     * @param <E> ԋpľ^
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @return SQL̎s
     */
    <E> List<E> executeForObjectList(String sqlID,
            Object bindParams);

    /**
     * SQL̎sʂMapListɊi[ĕԋpB
     * 
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @return SQL̎s
     */
    List<Map<String, Object>> executeForMapList(String sqlID,
            Object bindParams);

    /**
     * SQL̎sʂw肳ꂽCfbNXw肳ꂽsA
     * w肳ꂽ^ListŕԋpB
     * 
     * @param <E> ԋpľ^
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param beginIndex 擾JnCfbNX
     * @param maxCount 擾錏
     * @return SQL̎s
     */
    <E> List<E> executeForObjectList(String sqlID,
            Object bindParams, int beginIndex, int maxCount);

    /**
     * SQL̎sʂw肳ꂽCfbNXw肳ꂽsA
     * MapListɂĕԋpB
     * 
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param beginIndex 擾JnCfbNX
     * @param maxCount 擾錏
     * @return SQL̎s
     */
    List<Map<String, Object>> executeForMapList(String sqlID,
            Object bindParams, int beginIndex, int maxCount);


}