/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.standard;


import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

import jp.terasoluna.fw.batch.core.BLogicResultHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.messages.BLogicMessage;
import jp.terasoluna.fw.batch.messages.BLogicMessages;
import jp.terasoluna.fw.batch.messages.MessageAccessor;
import jp.terasoluna.fw.batch.openapi.BLogicResult;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <code>BLogicResultHandler</code> C^tF[X̕WNXB
 * 
 * <p>rWlXWbNʂ <code>JobStatus</code> ɔfAG[ł
 * ꍇɂ̓Oo͂B</p>
 * 
 */
public class StandardBLogicResultHandler implements BLogicResultHandler {

    /**
     * OCX^XB
     */
    private static Log log =
        LogFactory.getLog(StandardBLogicResultHandler.class);

    /**
     * bZ[W擾NX̃CX^XB
     */
    private MessageAccessor messageAccessor = null;
    
    /**
     * bZ[W̏o̓OxB
     */
    private LOG_TYPE bLogicMessagesLogLevel = LOG_TYPE.INFO;
    
    /**
     * G[bZ[W̏o̓OxB
     */
    private LOG_TYPE bLogicErroresLogLevel = LOG_TYPE.ERROR;
    
    /**
     * OxB 
     *
     */
    protected enum LOG_TYPE {
        /**
         * TRACEB
         */
        TRACE,
        /**
         * DEBUGB
         */
        DEBUG,
        /** 
         * INFOB
         */
        INFO,
        /** 
         * WARNB
         */
        WARN,
        /** 
         * ERRORB
         */
        ERROR,
        /** 
         * FATALB
         */
        FATAL
    }
    
    /**
     * BLogic̏ʂB
     * 
     * @param blogicResult rWlXWbN
     * @param blogicInputData rWlXWbN̓̓f[^
     * @param jobStatus WuXe[^X
     * @param batchUpdateMapList ob`XVXg
     */
    public void handle(BLogicResult blogicResult, Object blogicInputData,
            JobStatus jobStatus, 
            List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        jobStatus.countBLogic(blogicResult.getReturnCode());
        
        // BLogicResultɐݒ肳ꂽbZ[W̏sB
        processBLogicMessages(blogicResult);

        switch (blogicResult.getReturnCode()) {
        case NORMAL_CONTINUE:
            processNormalContinue(jobStatus, blogicResult, batchUpdateMapList);
            break;
        case NORMAL_END:
            processNormalEnd(jobStatus, blogicResult, batchUpdateMapList);
            break;
        case ERROR_CONTINUE:
            processErrorContinue(blogicInputData, jobStatus, blogicResult);
            break;
        case ERROR_END:
            processErrorEnd(blogicInputData, jobStatus, blogicResult);
            break;
        default:
            throw new IllegalArgumentException(blogicResult.getReturnCode()
                    + " illegal ReturnCode");
        }
    }
    
    /**
     * {@link BLogicMessages}̏sB<br />
     * {@link BLogicResult}{@link BLogicResult#setErrors(BLogicMessages)}
     * {@link BLogicResult#setMessages(BLogicMessages)}Őݒ肳ꂽbZ[W
     * sB<br />
     * <br />
     * ftHg͈ȉłB<br />
     * <li>setMessages(BLogicMessages): INFOx̃Ȍo</li>
     * <li>setErrors(BLogicMessages): ERRORx̃Ȍo</li>
     * <br /><br />
     * ̃\bhĒ`邱ƂBLogicMessagȅύX邱ƂłB
     * 
     * @param blogicResult rWlXWbN
     */
    protected void processBLogicMessages(BLogicResult blogicResult) {
        // messagesinfoOo
        writeBLogicMessagesLog(blogicResult.getMessages(),
                bLogicMessagesLogLevel);
        
        // errorserrorOo
        writeBLogicMessagesLog(blogicResult.getErrors(), bLogicErroresLogLevel);
    }

    /**
     * <code>BLogicResult</code> ̃^[R[h <code>NORMAL_CONTINUE</code>
     *  łƂ̏sB
     * 
     * <p>BLogicResultob`XVێĂꍇɂ́Aob`XVXg
     * ǉB</p>
     *
     * @param jobStatus WuXe[^X
     * @param bLogicResult rWlXWbN
     * @param batchUpdateMapList ob`XVXg
     */
    protected void processNormalContinue(JobStatus jobStatus, 
            BLogicResult bLogicResult, 
            List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        if (bLogicResult.getBatchUpdateMap() != null 
                && bLogicResult.getBatchUpdateMap().size() > 0) {
            batchUpdateMapList.add(bLogicResult.getBatchUpdateMap());
        }
    }

    /**
     * <code>BLogicResult</code> ̃^[R[h <code>NORMAL_END</code> 
     * Ƃ̏sB
     * 
     * <p>BLogicResultob`XVێĂꍇɂ́Aob`XVXg
     * ǉB</p>
     * 
     * <p>JobStatus</p> ̃Wu <code>JobStatus.STATE.ENDING_NORMALLY
     * </code> ɍXVA<code>BLogicResult<code>
     * ̃WuIR[h <code>JobStatus</code> ɔfB</p>
     *
     * @param jobStatus WuXe[^X
     * @param bLogicResult rWlXWbN
     * @param batchUpdateMapList ob`XVXg
     */
    protected void processNormalEnd(JobStatus jobStatus,
            BLogicResult bLogicResult,
            List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        if (bLogicResult.getBatchUpdateMap() != null 
                && bLogicResult.getBatchUpdateMap().size() > 0) {
            batchUpdateMapList.add(bLogicResult.getBatchUpdateMap());
        }
        jobStatus.setJobState(JobStatus.STATE.ENDING_NORMALLY);
        jobStatus.setJobExitCode(bLogicResult.getJobExitCode());
    }

    /**
     * <code>BLogicResult</code> ̃^[R[h <code>ERROR_CONTINUE</code>
     *  łƂ̏sB
     *
     * <p>xOo͂B</p>
     * 
     * <p><code>BLogicResult</code> WuIR[hĂꍇ<code>JobStatus</code> ɔfB</p>
     * <p><code>BLogicResult</code> ob`XVĂꍇłB</p>
     *
     * @param blogicInputData rWlXWbN̓̓f[^
     * @param jobStatus WuXe[^X
     * @param blogicResult rWlXWbN
     */
    protected void processErrorContinue(Object blogicInputData,
            JobStatus jobStatus, BLogicResult bLogicResult) {
        writeWarnLog("Business logic result code is ERROR_CONTINUE",
                jobStatus, bLogicResult, blogicInputData);
    }

    /**
     * <code>BLogicResult</code> ̃^[R[h <code>ERROR_END</code> 
     * Ƃ̏sB
     *
     * <p>G[Oo͂B</p>
     * 
     * <p>JobStatus</p> ̃Wu <code>JobStatus.STATE.ENDING_ABNORMALLY
     * </code> ɍXVA<code>BLogicResult<code>
     * ̃WuIR[h <code>JobStatus</code> ɔfB</p>
     *
     * @param blogicInputData rWlXWbN̓̓f[^
     * @param jobStatus WuXe[^X
     * @param bLogicResult rWlXWbN
     */
    protected void processErrorEnd(Object blogicInputData,
            JobStatus jobStatus, BLogicResult bLogicResult) {
        writeErrorLog("Business logic result code is ERROR_END",
                jobStatus, bLogicResult, blogicInputData);
        jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
        jobStatus.setJobExitCode(bLogicResult.getJobExitCode());
    }

    /**
     * rWlXWbNł̃G[f[^Oɏo͂B
     * 
     * @param message bZ[W
     * @param jobStatus WuXe[^X
     * @param bLogicResult rWlXWbN
     * @param blogicInputData rWlXWbN̓̓f[^
     */
    protected void writeErrorLog(String message, JobStatus jobStatus,
            BLogicResult bLogicResult, Object blogicInputData) {
        StringBuilder logStr = new StringBuilder(message);
        logStr.append(" : [jobId=");
        logStr.append(jobStatus.getJobId());
        logStr.append("] [jobRequestNo=");
        logStr.append(jobStatus.getJobRequestNo());
        logStr.append("] [partitionNo=");
        logStr.append(jobStatus.getPartitionNo());
        logStr.append("] [InputData: ");
        logStr.append(blogicInputData);
        logStr.append("]");
        log.error(logStr.toString());
    }

    /**
     * rWlXWbNł̌xf[^Oɏo͂B
     * 
     * @param message bZ[W
     * @param jobStatus WuXe[^X
     * @param bLogicResult rWlXWbN
     * @param blogicInputData rWlXWbN̓̓f[^
     */
    protected void writeWarnLog(String message, JobStatus jobStatus,
            BLogicResult bLogicResult, Object blogicInputData) {
        StringBuilder logStr = new StringBuilder(message);
        logStr.append(" : [jobId=");
        logStr.append(jobStatus.getJobId());
        logStr.append("] [jobRequestNo=");
        logStr.append(jobStatus.getJobRequestNo());
        logStr.append("] [partitionNo=");
        logStr.append(jobStatus.getPartitionNo());
        logStr.append("] [InputData: ");
        logStr.append(blogicInputData);
        logStr.append("]");
        log.warn(logStr.toString());
    }

    /**
     * BLogicMessageXgw̃Ox֏o͂B
     * 
     * @param blogicMessages BLogicMessageXg
     * @param logType Ox
     */
    protected void writeBLogicMessagesLog(BLogicMessages blogicMessages,
            LOG_TYPE logType) {
        //bZ[WNullȂꍇ͉ȂB
        if (blogicMessages == null || blogicMessages.isEmpty()) {
            return;
        }
        // BLogicMessages擾pCe[^
        Iterator itr = blogicMessages.get();
        while (itr.hasNext()) {
            // BLogicMessage擾
            BLogicMessage blogicMessage = (BLogicMessage) itr.next();

            if (blogicMessage.isResource()) {
                writeLog(messageAccessor.getMessage(blogicMessage.getKey(),
                        blogicMessage.getValues()), logType);
            } else {
                writeLog(blogicMessage.getKey(), logType);
            }
        }
    }

    /**
     * w̃OxփbZ[Wo͂B
     * 
     * @param message bZ[W
     * @param logType Ox
     */
    protected void writeLog(String message, LOG_TYPE logType) {
        switch (logType) {
        case TRACE:
            if (log.isFatalEnabled()) {
                log.trace(message);
            }
            break;
        case DEBUG:
            if (log.isDebugEnabled()) {
                log.debug(message);
            }
            break;
        case INFO:
            if (log.isInfoEnabled()) {
                log.info(message);
            }
            break;
        case WARN:
            log.warn(message);
            break;
        case ERROR:
            log.error(message);
            break;
        case FATAL:
            log.fatal(message);
            break;
        default:
            throw new IllegalArgumentException("No log Type which agrees.");
        }
    }
    
    /**
     * bZ[W擾NX̃CX^Xݒ肷B
     * 
     * @param messageAccessor
     *            bZ[W擾NX̃CX^X
     */
    public void setMessageAccessor(MessageAccessor messageAccessor) {
        this.messageAccessor = messageAccessor;
    }

    /**
     * rWlXWbNŐꂽG[bZ[W̏o̓Oxݒ肷B
     * @param logLevel o̓Ox
     */
    public void setBLogicErroresLogLevel(String logLevel) {
        bLogicErroresLogLevel = LOG_TYPE.valueOf(logLevel);
    }

    /**
     * rWlXWbNŐꂽbZ[W̏o̓Oxݒ肷B
     * @param logLevel o̓Ox
     */
    public void setBLogicMessagesLogLevel(String logLevel) {
        bLogicMessagesLogLevel = LOG_TYPE.valueOf(logLevel);
    }

}
