/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.init;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;

import jp.terasoluna.fw.batch.core.JobStatus;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * WuIt@C`FbNNXB<br>
 * WuIt@C̃t@CɂďIsB<br>
 * <br>
 * WuIt@C̃t@C̍\͈ȉłB<br>
 * E&lt;WuID&gt;.&lt;IʃL[&gt;<br>
 * E&lt;WuID&gt;_&lt;Wu˗ԍ&gt;.&lt;IʃL[&gt;<br>
 * @<br>
 * @&lt;WuID&gt;_&lt;WuvZXID&gt;.&lt;IʃL[&gt;<br>
 * <br>
 * IʃL[͈ȉQ܂B<br>
 * EIFend<br>
 * EfIFirp<br>
 * <br>
 * w肳ꂽgȊO̊gݒ肳ꂽt@CIt@CfBNg
 * ݂ꍇ͊ĎƂɌxOB<br>
 * 
 * ܂At@C"."ł͂Ȃꍇ͊ĎΏۊOt@CƔfB<br>
 * 
 * 
 */
public class EndFileChecker extends TimerTask {

    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(EndFileChecker.class);

    /**
     * IʃL[B
     */
    private static final String EXTENSION_IMMEDIATE = "end";

    /**
     * fIʃL[B
     */
    private static final String EXTENSION_GRACEFUL = "irp";

    /**
     * 󋵊i[pMapB
     */
    private Map<String, JobStatus> jobStatusMap;

    /**
     * It@CfBNgB
     */
    private String endFileDir = null;

    /**
     * RXgN^B
     * Wu󋵊i[pMapB
     *
     */
    public EndFileChecker() {
        jobStatusMap = new HashMap<String, JobStatus>();
    }

    /**
     * WuIt@CĎNp\bhB
     *
     */
    @Override
    public synchronized void run() {
        File dir = new File(endFileDir);

        if (!jobStatusMap.isEmpty()) {
            processEnd(dir);
        }
    }

    /**
     * eWũWuXe[^Xݒ肷B
     *
     * @param jobStatus
     *            eWu̎
     * @param jobID
     *            WuID
     * @param jobOptionID
     *            WuvZXID ܂ Wus˗ԍ
     */
    public void addParentJobStatus(JobStatus jobStatus, String jobID,
            String jobOptionID) {
        
        if (jobStatus == null || jobID == null || "".equals(jobID)) {
            return;
        }
        
        if (jobOptionID == null || "".equals(jobOptionID)) {
            addJobStatus(jobID , jobStatus);    
        } else {
            addJobStatus(jobID + "_" + jobOptionID, jobStatus);
        }
    }

    /**
     * eWũWuXe[^X폜B
     *
     * @param jobStatus
     *            eWu̎
     * @param jobID
     *            WuID
     * @param jobOptionID
     *            WuvZXID ܂ Wus˗ԍ
     */
    public void removeParentJobStatus(JobStatus jobStatus, String jobID,
            String jobOptionID) {
        
        if (jobStatus == null || jobID == null || "".equals(jobID)) {
            return;
        }
        
        String key = null;
        
        if (jobOptionID == null || "".equals(jobOptionID)) {
            key = jobID;
        } else {
            key = jobID + "_" + jobOptionID;
        }
        
        JobStatus registedJobStatus = jobStatusMap.get(key);
        if (jobStatus.equals(registedJobStatus)) {
            removeJobStatus(key);
        }
    }

    /**
     * WuIsB
     *
     * @param endFileDir
     *            It@CfBNg
     */
    private void processEnd(File endFileDir) {
                
        String[] fileNames = endFileDir.list();

        if (fileNames == null || fileNames.length == 0) {
            return;
        }
        for (String fileName : fileNames) {
            String[] splitFileName = fileName.split("[.]");

            if (splitFileName.length == 2) {
                String endFileName = splitFileName[0];
                String endType = splitFileName[1];
                
                if (EXTENSION_GRACEFUL.equals(endType)
                        || EXTENSION_IMMEDIATE.equals(endType)) {
                    List<String> processKey = getProcessKey(endFileName);
                    endJob(endType, processKey);
                } else {
                    log.warn("\"" + fileName +
                            "\" is invalid file extension.");
                    continue;
                }
            }
        }
    }

    /**
     * WuIB
     *
     * @param endType I
     * @param processKey IΏۂMap
     */
    private void endJob(String endType, List<String> processKey) {

        for (String key : processKey) {

            JobStatus jobStatus = jobStatusMap.get(key);

            if (EXTENSION_IMMEDIATE.equals(endType)) {
                jobStatus.shutdownImmediate();
                if (log.isInfoEnabled()) {
                    log.info(key + " shutdown_immediate");
                }
                removeJobStatus(key);
            } else if (EXTENSION_GRACEFUL.equals(endType)) {
                jobStatus.shutdownGraceful();
                if (log.isInfoEnabled()) {
                    log.info(key + " shutdown_graceful");
                }
                removeJobStatus(key);
            }
        }
    }
    
    /**
     * WuXe[^X}bvɓo^B
     * @param key o^L[
     * @param jobStatus WuXe[^X
     */
    private void addJobStatus(String key, JobStatus jobStatus) {
        jobStatusMap.put(key, jobStatus);
        if (log.isDebugEnabled()) {
            log.debug(key +  " jobstatus was added to the map.");
        }
    }
    
    /**
     * IsWuXe[^X}bv폜B
     * @param key o^L[
     */
    private void removeJobStatus(String key) {
        jobStatusMap.remove(key);
        if (log.isDebugEnabled()) {
            log.debug(key +  " jobstatus removed from the map.");
        }
    }

    /**
     * IΏۂ̃}bvɓo^ꂽL[擾B
     *
     * @param endFileName It@C
     * @return IΏۂMapɓo^ꂽL[
     */
    private List<String> getProcessKey(String endFileName) {
        
        Set<String> keyset = jobStatusMap.keySet();
        List<String> processKey = new ArrayList<String>();
        
        String processKeyPrefix = endFileName + "_";
        
        for (String jobStatusKey : keyset) {
                if (jobStatusKey.equals(endFileName)
                        || jobStatusKey.startsWith(processKeyPrefix)) {
                processKey.add(jobStatusKey);
            }
        }

        return processKey;
    }

    /**
     * It@CfBNgݒ肷B
     *
     * @param endFileDir It@CfBNg
     */
    public void setEndFileDir(String endFileDir) {
        this.endFileDir = endFileDir;
    }
}
