/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.commonj.transaction;

import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.batch.jobmessage.JobMessageInfo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

/**
 * Wusʃe[uɓo^nhB<br>
 * 
 * 
 */
public class JobResultInfoHandlerImpl implements JobResultInfoHandler {

    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(
                JobResultInfoHandlerImpl.class);

    /**
     * UPDATEpDAOB SpringDI@\pĐݒ肷B
     */
    private UpdateDAO updateDAO = null;

    /**
     * gUNV}l[WB
     */
    private PlatformTransactionManager transactionManager = null;

    /**
     * WusǗ֓o^SQLIDB
     */
    private static final String INSERT_JOB_RESULT 
            = "jobResult.INSERT_JOB_RESULT";

    /**
     * JOB_RESULTe[uɃWu̎sʂo^B
     * 
     * @param jobMessageInfo WuǗ
     * @return o^
     */
    public int handle(JobMessageInfo jobMessageInfo) {
        printDebugLog("Job result registration processing starting.",
                jobMessageInfo);
        int count = 0;
        TransactionStatus transactionStatus =
            transactionManager.getTransaction(null);
        try {
            count = updateDAO.execute(INSERT_JOB_RESULT, jobMessageInfo);
            if (count == 1) {
                //sʂo^ɐB
                transactionManager.commit(transactionStatus);
                printDebugLog("Job result registration processing success.",
                        jobMessageInfo);
            } else {
                //sʂo^ɎsB
                transactionManager.rollback(transactionStatus);
                printErrorLog("Job result registration processing failure.",
                        jobMessageInfo);
            }
        } catch (UncategorizedSQLException e) {
            transactionManager.rollback(transactionStatus);
            log.error(e.getMessage(), e);
        }
        return count;
    }

    /**
     * UPDATEpDAOB
     * 
     * @param updateDAO UPDATEpDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

    /**
     * gUNV}l[WB
     * 
     * @param transactionManager gUNV}l[W
     */
    public void setTransactionManager(
            PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    /**
     * fobNOóB
     * 
     * @param message ObZ[W
     * @param jobMessageInfo WubZ[WǗ
     */
    private void printDebugLog(String message, JobMessageInfo jobMessageInfo) {
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(message);
            builder.append(": [jobId=");
            builder.append(jobMessageInfo.getJobId());
            builder.append("] [jobRequestNo=");
            builder.append(jobMessageInfo.getJobRequestNo());
            builder.append("] [partitionNo=");
            builder.append(jobMessageInfo.getPartitionNo());
            builder.append("] [partitionKey=");
            builder.append(jobMessageInfo.getPartitionKey());
            builder.append("] [jobExitCode=");
            builder.append(jobMessageInfo.getJobExitCode());
            builder.append("] [JobState=");
            builder.append(jobMessageInfo.getJobState());
            builder.append("]");
            log.debug(builder.toString());
        }
    }
    
    /**
     * G[OóB
     * 
     * @param message ObZ[W
     * @param jobMessageInfo WubZ[WǗ
     */
    private void printErrorLog(String message, JobMessageInfo jobMessageInfo) {
        StringBuilder builder = new StringBuilder(message);
        builder.append(": [jobId=");
        builder.append(jobMessageInfo.getJobId());
        builder.append("] [jobRequestNo=");
        builder.append(jobMessageInfo.getJobRequestNo());
        builder.append("] [partitionNo=");
        builder.append(jobMessageInfo.getPartitionNo());
        builder.append("] [partitionKey=");
        builder.append(jobMessageInfo.getPartitionKey());
        builder.append("] [jobExitCode=");
        builder.append(jobMessageInfo.getJobExitCode());
        builder.append("] [JobState=");
        builder.append(jobMessageInfo.getJobState());
        builder.append("]");
        log.error(builder.toString());
    }
}
