/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.wiring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import org.springframework.beans.factory.wiring.ClassNameBeanWiringInfoResolver;
import org.springframework.util.Assert;

public abstract class BeanConfigurerSupport
implements BeanFactoryAware,
InitializingBean,
DisposableBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    private BeanWiringInfoResolver beanWiringInfoResolver;
    private AutowireCapableBeanFactory beanFactory;

    public void setBeanWiringInfoResolver(BeanWiringInfoResolver beanWiringInfoResolver) {
        Assert.notNull(beanWiringInfoResolver, "'beanWiringInfoResolver' cannot be null.");
        this.beanWiringInfoResolver = beanWiringInfoResolver;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof AutowireCapableBeanFactory)) {
            throw new IllegalArgumentException("Bean configurer aspect needs to run in an AutowireCapableBeanFactory, not in [" + beanFactory + "]");
        }
        this.beanFactory = (AutowireCapableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.beanWiringInfoResolver == null) {
            this.beanWiringInfoResolver = new ClassNameBeanWiringInfoResolver();
        }
    }

    public void destroy() {
        this.beanFactory = null;
        this.beanWiringInfoResolver = null;
    }

    protected void configureBean(Object beanInstance) {
        if (this.beanWiringInfoResolver == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("[" + this.getClass().getName() + "] has not been configured by Spring " + "and is unable to configure bean instances. Object with identity " + "hashcode " + System.identityHashCode(beanInstance) + " has not been configured: " + "Make sure this configurer runs in a Spring container. " + "For example, add it to a Spring application context as an XML bean definition."));
            }
            return;
        }
        BeanWiringInfo bwi = this.beanWiringInfoResolver.resolveWiringInfo(beanInstance);
        if (bwi == null) {
            return;
        }
        if (this.beanFactory == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("BeanFactory has not been set on [" + this.getClass().getName() + "]: " + "Make sure this configurer runs in a Spring container. " + "For example, add it to a Spring application context as an XML bean definition."));
            }
            return;
        }
        if (bwi.indicatesAutowiring()) {
            this.beanFactory.autowireBeanProperties(beanInstance, bwi.getAutowireMode(), bwi.getDependencyCheck());
        } else {
            this.beanFactory.applyBeanPropertyValues(beanInstance, bwi.getBeanName());
        }
    }
}

