/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.springsupport.standard;

import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jp.terasoluna.fw.batch.core.InitializeException;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.standard.QueueProcessor;
import jp.terasoluna.fw.batch.standard.RunnableQueueProcessor;
import jp.terasoluna.fw.batch.standard.WorkerExecutorService;
import org.springframework.beans.factory.DisposableBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedThreadPoolWorkerExecutorService
implements WorkerExecutorService,
DisposableBean {
    private ExecutorService executorService = null;
    private LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap = null;
    private JobExceptionHandler defaultJobExceptionHandler = null;

    public FixedThreadPoolWorkerExecutorService(int threads) {
        if (threads <= 0) {
            StringBuilder builder = new StringBuilder("Threads is illegal. ");
            builder.append(threads);
            throw new InitializeException(builder.toString());
        }
        this.executorService = Executors.newFixedThreadPool(threads);
    }

    @Override
    public Future<?> submit(QueueProcessor queueProcessor, WorkQueue workQueue, JobStatus jobStatus) {
        return this.executorService.submit(new RunnableQueueProcessor(queueProcessor, workQueue, jobStatus, this.exceptionHandlerMap, this.defaultJobExceptionHandler));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    public void setExceptionHandlerMap(LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }

    public void setDefaultJobExceptionHandler(JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }
}

