/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.sample.job01;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.batch.messages.MessageAccessor;
import jp.terasoluna.fw.batch.openapi.BLogic;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.sample.commons.ZandakaData;

/**
 * rWlXWbNNX
 */
public class DBBLogic implements BLogic<NyukinFileData, DBJobContext> {

    /**
     * ONXB
     */
    private static final Log log = LogFactory.getLog(DBBLogic.class);
    
    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private QueryDAO queryDAO = null;
    
    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private UpdateDAO updateDAO = null;
   
    /**
     * bZ[W擾NXB
     * SpringɂCX^Xݒ肳B
     */
    private MessageAccessor messageAccessor = null;
    
    /**
     * rWlXWbNsB
     * @param nyukinData ̓p[^
     * @param jobContext WuReLXg
     */
    public BLogicResult execute(NyukinFileData nyukinData, DBJobContext jobContext) {
    	
    	
    	//Ɖ^pt̔r
    	Date torihikibi = nyukinData.getTorihikibi();
    	Date unyohiduke = jobContext.getUnyohiduke();
    	
    	
    	if(!torihikibi.before(unyohiduke)){
    		
    		// >= ^pt Ȃ΃bZ[W擾Oɏo͂B
    		String[] args = {nyukinData.getKokyakuid()};
    		String message = messageAccessor.getMessage("msg.SampleMsg",args);
    		
    		log.warn(message);
    		
    		
    		/* u2.2.5 O̎vł͈ȉ̃RgsLɂB */
    		/*
    		 //rWlXWbNʃIuWFNgԋpB
    		  BLogicResult result = new BLogicResult(ReturnCode.ERROR_END);	    
    		  return result;
    		  */
    	}
    	
    	//ce[uQ
    	ZandakaData zandakaData = queryDAO.executeForObject("Sample.getZandakaData", nyukinData.getKokyakuid() , ZandakaData.class);
    	
    	//YR[hꍇ͎cvZƍXV
    	if(zandakaData != null){
    		int zandaka = zandakaData.getZandaka() + nyukinData.getNyukin();
    		zandakaData.setZandaka(zandaka);
    		zandakaData.setSaisyutorihikibi(nyukinData.getTorihikibi());
    		zandakaData.setKokyakuid(nyukinData.getKokyakuid());
    		updateDAO.execute("Sample.updateZandakaData", zandakaData);
    		
    		//YR[hꍇ͐VK쐬
    	}else{
    		zandakaData = new ZandakaData();
    		zandakaData.setKokyakuid(nyukinData.getKokyakuid());
    		zandakaData.setZandaka(nyukinData.getNyukin());
    		zandakaData.setSaisyutorihikibi(nyukinData.getTorihikibi());
    		updateDAO.execute("Sample.insertZandakaData", zandakaData);
    	}
    	
    	//JEgAbv
    	jobContext.incrementCount();
    	
    	//rWlXWbNʃIuWFNgԋp
    	//Cӂ̃WuIR[hݒ肷ꍇ́Aȉ̂悤ɑ2ɃWuIR[hw肷B
    	BLogicResult result = new BLogicResult(ReturnCode.NORMAL_CONTINUE);
    	
    	return result;
    }

    /**
     * QueryDAOݒ肷B
     * @param queryDAO ݒ肷QueryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }

    /**
     * UpdateDAOݒ肷B
     * @param updateDAO ݒ肷UpdateDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

    /**
     * bZ[W擾NXݒ肷B
     * @param messageAccessor bZ[W擾NX
     */
    public void setMessageAccessor(MessageAccessor messageAccessor) {
        this.messageAccessor = messageAccessor;
    }  

}
