#include <altivec.h>

// work around a compiler bug
#define ALREADY_HAS_QCMS_BOOL
#include "qcmsint.h"
#undef ALREADY_HAS_QCMS_BOOL

// Tobias' qcms VMX implementation

#undef COPY_CONSTANTS_TO_ALIGNED_LOCATION

#define FLOATSCALE  (float)(PRECACHE_OUTPUT_SIZE)
#define CLAMPMAXVAL ( ((float) (PRECACHE_OUTPUT_SIZE - 1)) / PRECACHE_OUTPUT_SIZE )
static const ALIGN float floatScaleX4 = FLOATSCALE;
static const ALIGN float clampMaxValueX4 = CLAMPMAXVAL;

#ifndef COPY_CONSTANTS_TO_ALIGNED_LOCATION
#define load_aligned_float( result, dataPtr ,moveToStart) \
{ \
    result = vec_lde( 0, dataPtr ); \
    moveToStart = vec_lvsl( 0, dataPtr ); \
    result = vec_perm( result, result, moveToStart ); \
}
#endif

void qcms_transform_data_rgb_out_lut_vmx(qcms_transform *transform,
                                          unsigned char *src,
                                          unsigned char *dest,
                                          size_t length)
{
    unsigned int i;
    float (*mat)[4] = transform->matrix;
    char input_back[32];
    /* Ensure we have a buffer that's 16 byte aligned regardless of the original
     * stack alignment. We can't use __attribute__((aligned(16))) or __declspec(align(32))
     * because they don't work on stack variables. gcc 4.4 does do the right thing
     * on x86 but that's too new for us right now. For more info: gcc bug #16660 */
    float const * input = (float*)(((uintptr_t)&input_back[16]) & ~0xf);
    /* share input and output locations to save having to keep the
     * locations in separate registers */
    uint32_t const * output = (uint32_t*)input;

    /* deref *transform now to avoid it in loop */
    const float *igtbl_r = transform->input_gamma_table_r;
    const float *igtbl_g = transform->input_gamma_table_g;
    const float *igtbl_b = transform->input_gamma_table_b;

    /* deref *transform now to avoid it in loop */
    const uint8_t *otdata_r = &transform->output_table_r->data[0];
    const uint8_t *otdata_g = &transform->output_table_g->data[0];
    const uint8_t *otdata_b = &transform->output_table_b->data[0];

    /* input matrix values never change */
    register const vector float mat0 = vec_ldl(0,(vector float *)mat[0]);
    register const vector float mat1 = vec_ldl(0,(vector float *)mat[1]);
    register const vector float mat2 = vec_ldl(0,(vector float *)mat[2]);

    /* these values don't change, either */
    register const vector float max = vec_splat( vec_lde( 0, (float *)&clampMaxValueX4 ), 0 );
    register const vector float min = (vector float) vec_splat_u32(0);
    register const vector float scale = vec_splat( vec_lde( 0, (float *)&floatScaleX4 ), 0 );

#ifndef COPY_CONSTANTS_TO_ALIGNED_LOCATION
    register vector unsigned char temp;
#endif

    /* working variables */
    register vector float vec_r, vec_g, vec_b, result;
#ifdef COPY_CONSTANTS_TO_ALIGNED_LOCATION
    float ALIGN igtbl_r_, igtbl_g_, igtbl_b_;
#endif

    /* CYA */
    if (!length)
        return;

    /* one pixel is handled outside of the loop */
    length--;

    /* setup for transforming 1st pixel */
#ifdef COPY_CONSTANTS_TO_ALIGNED_LOCATION
    igtbl_r_ = igtbl_r[src[0]];
    igtbl_g_ = igtbl_g[src[1]];
    igtbl_b_ = igtbl_b[src[2]];
    vec_r = vec_lde(0, &igtbl_r_);
    vec_g = vec_lde(0, &igtbl_g_);
    vec_b = vec_lde(0, &igtbl_b_);
#else
    load_aligned_float(vec_r, (float *)&igtbl_r[src[0]], temp);
    load_aligned_float(vec_g, (float *)&igtbl_r[src[1]], temp);
    load_aligned_float(vec_b, (float *)&igtbl_r[src[2]], temp);
#endif
    src += 3;

    /* transform all but final pixel */

    for (i=0; i<length; i++)
    {
        /* position values from gamma tables */
        vec_r = vec_splat(vec_r, 0);
        vec_g = vec_splat(vec_g, 0);
        vec_b = vec_splat(vec_b, 0);

        /* gamma * matrix */
        vec_r = vec_madd(vec_r, mat0, min);
        vec_g = vec_madd(vec_g, mat1, min);
        vec_b = vec_madd(vec_b, mat2, min);

        /* crunch, crunch, crunch */
        vec_r  = vec_add(vec_r, vec_add(vec_g, vec_b));
        vec_r  = vec_max(min, vec_r);
        vec_r  = vec_min(max, vec_r);
        result = vec_madd(vec_r, scale, min);

        /* store calc'd output tables indices */
        vec_st(vec_ctu(vec_round(result),0),0,(vector unsigned int *)output);

        /* load for next loop while store completes */
#ifdef COPY_CONSTANTS_TO_ALIGNED_LOCATION
        igtbl_r_ = igtbl_r[src[0]];
        igtbl_g_ = igtbl_g[src[1]];
        igtbl_b_ = igtbl_b[src[2]];
        vec_r = vec_lde(0, &igtbl_r_);
        vec_g = vec_lde(0, &igtbl_g_);
        vec_b = vec_lde(0, &igtbl_b_);
#else
        load_aligned_float(vec_r, (float *)&igtbl_r[src[0]], temp);
        load_aligned_float(vec_g, (float *)&igtbl_r[src[1]], temp);
        load_aligned_float(vec_b, (float *)&igtbl_r[src[2]], temp);
#endif
        src += 3;

        /* use calc'd indices to output RGB values */
        dest[0] = otdata_r[output[0]];
        dest[1] = otdata_g[output[1]];
        dest[2] = otdata_b[output[2]];
        dest += 3;
    }

    /* handle final (maybe only) pixel */

    vec_r = vec_splat(vec_r, 0);
    vec_g = vec_splat(vec_g, 0);
    vec_b = vec_splat(vec_b, 0);

    vec_r = vec_madd(vec_r, mat0, min);
    vec_g = vec_madd(vec_g, mat1, min);
    vec_b = vec_madd(vec_b, mat2, min);

    vec_r  = vec_add(vec_r, vec_add(vec_g, vec_b));
    vec_r  = vec_max(min, vec_r);
    vec_r  = vec_min(max, vec_r);
    result = vec_madd(vec_r, scale, min);

    vec_st(vec_ctu(vec_round(result),0),0,(vector unsigned int *)output);

    dest[0] = otdata_r[output[0]];
    dest[1] = otdata_g[output[1]];
    dest[2] = otdata_b[output[2]];
}

void qcms_transform_data_rgba_out_lut_vmx(qcms_transform *transform,
                                           unsigned char *src,
                                           unsigned char *dest,
                                           size_t length)
{
    unsigned int i;
    float (*mat)[4] = transform->matrix;
    char input_back[32];
    /* Ensure we have a buffer that's 16 byte aligned regardless of the original
     * stack alignment. We can't use __attribute__((aligned(16))) or __declspec(align(32))
     * because they don't work on stack variables. gcc 4.4 does do the right thing
     * on x86 but that's too new for us right now. For more info: gcc bug #16660 */
    float const * input = (float*)(((uintptr_t)&input_back[16]) & ~0xf);
    /* share input and output locations to save having to keep the
     * locations in separate registers */
    uint32_t const * output = (uint32_t*)input;

    /* deref *transform now to avoid it in loop */
    const float *igtbl_r = transform->input_gamma_table_r;
    const float *igtbl_g = transform->input_gamma_table_g;
    const float *igtbl_b = transform->input_gamma_table_b;

    /* deref *transform now to avoid it in loop */
    const uint8_t *otdata_r = &transform->output_table_r->data[0];
    const uint8_t *otdata_g = &transform->output_table_g->data[0];
    const uint8_t *otdata_b = &transform->output_table_b->data[0];

    /* input matrix values never change */
    register const vector float mat0 = vec_ldl(0,(vector float *)mat[0]);
    register const vector float mat1 = vec_ldl(0,(vector float *)mat[1]);
    register const vector float mat2 = vec_ldl(0,(vector float *)mat[2]);

    /* these values don't change, either */
    register const vector float max = vec_splat( vec_lde( 0, (float *)&clampMaxValueX4 ), 0 );
    register const vector float min = (vector float) vec_splat_u32(0);
    register const vector float scale = vec_splat( vec_lde( 0, (float *)&floatScaleX4 ), 0 );

#ifndef COPY_CONSTANTS_TO_ALIGNED_LOCATION
    register vector unsigned char temp;
#endif
    /* working variables */
    register vector float vec_r, vec_g, vec_b, result;
#ifdef COPY_CONSTANTS_TO_ALIGNED_LOCATION
    float ALIGN igtbl_r_, igtbl_g_, igtbl_b_;
#endif
    unsigned char alpha;

    /* CYA */
    if (!length)
        return;

    /* one pixel is handled outside of the loop */
    length--;

    /* setup for transforming 1st pixel */
#ifdef COPY_CONSTANTS_TO_ALIGNED_LOCATION
    igtbl_r_ = igtbl_r[src[0]];
    igtbl_g_ = igtbl_g[src[1]];
    igtbl_b_ = igtbl_b[src[2]];
    vec_r = vec_lde(0, &igtbl_r_);
    vec_g = vec_lde(0, &igtbl_g_);
    vec_b = vec_lde(0, &igtbl_b_);
#else
    load_aligned_float(vec_r, (float *)&igtbl_r[src[0]], temp);
    load_aligned_float(vec_g, (float *)&igtbl_r[src[1]], temp);
    load_aligned_float(vec_b, (float *)&igtbl_r[src[2]], temp);
#endif
    alpha = src[3];
    src += 4;

    /* transform all but final pixel */

    for (i=0; i<length; i++)
    {
        /* position values from gamma tables */
        vec_r = vec_splat(vec_r, 0);
        vec_g = vec_splat(vec_g, 0);
        vec_b = vec_splat(vec_b, 0);

        /* gamma * matrix */
        vec_r = vec_madd(vec_r, mat0, min);
        vec_g = vec_madd(vec_g, mat1, min);
        vec_b = vec_madd(vec_b, mat2, min);

        /* store alpha for this pixel; load alpha for next */
        dest[3] = alpha;
        alpha   = src[3];

        /* crunch, crunch, crunch */
        vec_r  = vec_add(vec_r, vec_add(vec_g, vec_b));
        vec_r  = vec_max(min, vec_r);
        vec_r  = vec_min(max, vec_r);
        result = vec_madd(vec_r, scale, min);

        /* store calc'd output tables indices */
        vec_st(vec_ctu(vec_round(result),0),0,(vector unsigned int *)output);

        /* load gamma values for next loop while store completes */
#ifdef COPY_CONSTANTS_TO_ALIGNED_LOCATION
        igtbl_r_ = igtbl_r[src[0]];
        igtbl_g_ = igtbl_g[src[1]];
        igtbl_b_ = igtbl_b[src[2]];
        vec_r = vec_lde(0, &igtbl_r_);
        vec_g = vec_lde(0, &igtbl_g_);
        vec_b = vec_lde(0, &igtbl_b_);
#else
        load_aligned_float(vec_r, (float *)&igtbl_r[src[0]], temp);
        load_aligned_float(vec_g, (float *)&igtbl_r[src[1]], temp);
        load_aligned_float(vec_b, (float *)&igtbl_r[src[2]], temp);
#endif
        src += 4;

        /* use calc'd indices to output RGB values */
        dest[0] = otdata_r[output[0]];
        dest[1] = otdata_g[output[1]];
        dest[2] = otdata_b[output[2]];
        dest += 4;
    }

    /* handle final (maybe only) pixel */

    vec_r = vec_splat(vec_r, 0);
    vec_g = vec_splat(vec_g, 0);
    vec_b = vec_splat(vec_b, 0);

    vec_r = vec_madd(vec_r, mat0, min);
    vec_g = vec_madd(vec_g, mat1, min);
    vec_b = vec_madd(vec_b, mat2, min);

    dest[3] = alpha;

    vec_r  = vec_add(vec_r, vec_add(vec_g, vec_b));
    vec_r  = vec_max(min, vec_r);
    vec_r  = vec_min(max, vec_r);
    result = vec_madd(vec_r, scale, min);

    vec_st(vec_ctu(vec_round(result),0),0,(vector unsigned int *)output);

    dest[0] = otdata_r[output[0]];
    dest[1] = otdata_g[output[1]];
    dest[2] = otdata_b[output[2]];
}

