#!/usr/bin/perl

# This shim allows you to change the linker with the LD64 variable. If the
# variable is 1, then it uses /usr/bin/ldx3; otherwise the value of the
# variable. If LD64 is undefined, zero or zero-length, /usr/bin/ld32 is used.
# It is assumed you have moved /usr/bin/ld to /usr/bin/ld32.
# ldx3 is the Xcode 3.0 linker for Tiger; see Google Code to download it.
# Public domain.
# Cameron Kaiser
# Provided with TenFourFox 5

$LD32 = "/usr/bin/ld32";
$LD64 = "/usr/bin/ldx3";
$my_exec = ($ENV{'LD64'} eq '1') ? $LD64
	: ($ENV{'LD64'} eq '0' || !length($ENV{'LD64'})) ? $LD32
	: (length($ENV{'LD64'})) ? $ENV{'LD64'}
	: $LD32;

exec($my_exec, @ARGV);
die("ld shim could not run $my_exec: $!\n");
