#ifndef _TMVECTOR_FUNCTIONS_HPP
#define _TMVECTOR_FUNCTIONS_HPP
/**
	@file vector_functions.hpp
	@brief Defines vecor functions.
	@author ototoi / Toru Matsuoka
	@date 2004/05/12 
*/

//#include<iofwd>
#include<ostream>
#include<sstream>

#include "vector_base.hpp"

namespace tempest{ 
	
//-----------------------------------------------
//Not a member!
//-----------------------------------------------

//-----------------------------------------------
//unary operator
/** 
	@name unary operator
	@relates vector
 */
//@{
	
template<class T,std::size_t Sz>
inline vector<T,Sz> operator+ (const vector<T,Sz> & rhs){
	return rhs;
}	
	
template<class T,std::size_t Sz>
inline vector<T,Sz> operator- (const vector<T,Sz> & rhs){
	return vector<T,Sz>(rhs) *= T(-1);
}	
//@}
	
//-----------------------------------------------
//binary operator
/** 
	@name binary operator
	@relates vector
 */
//@{ 

#define DECLARE_OPERATOR(OP)														\
template<class T,std::size_t Sz>													\
inline vector<T,Sz> operator OP (const vector<T,Sz> &lhs, const vector<T,Sz> &rhs){	\
	return vector<T,Sz>(lhs) OP ## = rhs;											\
}
	DECLARE_OPERATOR(+)	
	DECLARE_OPERATOR(-)	
	DECLARE_OPERATOR(*)	
	DECLARE_OPERATOR(/)
	
#undef DECLARE_OPERATOR

//@}
	
//-----------------------------------------------
//specific scalar
/** 
	@name specific scalar
	@relates vector
 */
//@{
	
	
/**
	@param lhs an any type.
	@param rhs a vector. 
	@return lhs * rhs 
 */	
template<class T, class X, std::size_t Sz> 
inline vector<T,Sz> operator* (const X lhs,const vector<T,Sz> & rhs){ 
	return vector<T,Sz>(rhs) *= lhs ; 
}
/**
	@param lhs a vector.
	@param rhs an any type.
	@return lhs * rhs 
 */
template<class T, class X, std::size_t Sz> 
inline vector<T,Sz> operator* (const vector<T,Sz> &lhs,const X rhs){ 
	return vector<T,Sz>(lhs) *= rhs ;
}

/**
	@param lhs a vector.
	@param rhs an any type.
	@return lhs / rhs 
 */
template<class T, class X, std::size_t Sz> 
inline vector<T,Sz> operator/ (const vector<T,Sz> &lhs,const X rhs){ 
	return vector<T,Sz>(lhs) /= rhs ;
}
//@}	

	
//-----------------------------------------------	
// utility functions
/** 
	@name utility
	@relates vector
 */
//@{
/**
	@param lhs a vector.
	@param rhs a vector.
	@return rhs/|| rhs ||
 */
template<class T,std::size_t Sz>
inline vector<T,Sz> normalize(const vector<T,Sz> &rhs){
	return vector<T,Sz>(rhs).normalize();
}

template<class T,std::size_t Sz>
inline T length(const vector<T,Sz> &rhs){
	return rhs.length();
}
/** 
	@param lhs a vector.
	@param rhs a vector.
	@return || rhs ||^2
 */
template<class T,std::size_t Sz>
inline T sqr_length(const vector<T,Sz> &rhs){
	return rhs.sqr_length();
}
/*
	@param lhs a vector.
	@param rhs a vector.
	@return lhs &dot; rhs 
 */
template<class T,std::size_t Sz>
inline T dot(const vector<T,Sz> &lhs,const vector<T,Sz> &rhs){
	T temp();
	for(std::size_t i = 0;i < Sz;i++){temp += (lhs[i]*rhs[i]);}
	return temp;
}
//@}
	
//--------------------------------------------------
//compare
/** 
	@name comparer
	@relates vector
 */
//@{
	
/** 
	@param lhs a vector.
	@param rhs a vector.
	@return lhs == rhs
 */	
template<class T,std::size_t Sz>
inline bool operator==(const vector<T,Sz> &lhs,const vector<T,Sz> &rhs){
	for(std::size_t i = 0;i<Sz;++i){if(lhs[i]!=rhs[i])return false;}
	return true;
}
/** 
	@param lhs a vector.
	@param rhs a vector.
	@return lhs != rhs
 */		
template<class T,std::size_t Sz>
inline bool operator!=(const vector<T,Sz> &lhs,const vector<T,Sz> &rhs){
	return !(lhs == rhs);
}
/** 
	@param lhs a vector.
	@param rhs a vector.
	@return lhs < rhs
 */	
template<class T,std::size_t Sz>
inline bool operator< (const vector<T,Sz> &lhs,const vector<T,Sz> &rhs){
	return lhs.sqr_length() < rhs.sqr_length();
}
/** 
	@param lhs a vector.
	@param rhs a vector.
	@return lhs > rhs
 */		
template<class T,std::size_t Sz>
inline bool operator> (const vector<T,Sz> &lhs,const vector<T,Sz> &rhs){
	return lhs.sqr_length() > rhs.sqr_length();
}
/** 
	@param lhs a vector.
	@param rhs a vector.
	@return lhs >= rhs
 */	
template<class T,std::size_t Sz>
inline bool operator>= (const vector<T,Sz> &lhs,const vector<T,Sz> &rhs){
	return !(lhs < rhs);
}
/** 
 *	@param lhs a vector.
 *	@param rhs a vector.
 *	@return lhs <= rhs
 */
 		
template<class T,std::size_t Sz>
inline bool operator<= (const vector<T,Sz> &lhs,const vector<T,Sz> &rhs){
	return !(lhs > rhs);
}

//@}
	
//-----------------------------------------------
//output
/** 
 *	@name output
 *	@relates vector
 */
//@{
	
/** 
 *	ostream << 
 */
template<typename T,std::size_t Sz, typename _CharT, class _Traits>
std::basic_ostream<_CharT, _Traits>& operator<<(std::basic_ostream<_CharT, _Traits>& os, const vector<T,Sz>& rhs){
	
	std::basic_ostringstream<_CharT, _Traits> s;
	s.flags(os.flags());
	s.imbue(os.getloc());
	s.precision(os.precision());
	s << "(";
	for(std::size_t i = 0; i < Sz-1; ++i){
		s << rhs[i] <<",";
	}
	s <<rhs[Sz-1] <<")";
	return os << s.str();
}

//@}
	
}//End of namespaces. 


#endif

