/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.filter;

import java.math.BigDecimal;
import java.math.RoundingMode;

import org.apache.commons.lang.ArrayUtils;

import jp.sf.tatooine.gtx.Filter;

/**
 * Devide.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/08/16
 * @since   JDK5.0 Tiger
 */
public class Devide implements Filter {

	/**
	 * @see jp.sf.tatooine.gtx.Filter#invoke(java.lang.String, java.lang.String[])
	 */
	public String invoke(String value, String[] args) {
		BigDecimal divisor = null;
		if (args.length < 1 || args.length > 2) {
			throw new IllegalArgumentException("引数が合致しません。devide(divisor[,scale]):" + ArrayUtils.toString(args));
		}
		divisor = new BigDecimal(args[0]);
		int scale = 0;
		if (args.length == 2) {
			scale = Integer.parseInt(args[1]);
		}
		BigDecimal dec = new BigDecimal(value);
		return dec.divide(divisor, scale, RoundingMode.HALF_UP).toString();
	}

}
