/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.filter;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

import jp.sf.tatooine.gtx.Filter;

/**
 * Mid.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/04/18
 * @since   JDK5.0 Tiger
 */
public class Mid implements Filter {

	/**
	 * @see jp.sf.tatooine.gtx.Filter#invoke(java.lang.String, java.lang.String[])
	 */
	public String invoke(String value, String[] args) {
		
		if (args.length != 2) {
			throw new IllegalArgumentException("引数が合致しません。mid(pos, len):" + ArrayUtils.toString(args));
		}
		if (!StringUtils.isNumeric(args[0]) || Integer.parseInt(args[0]) < 0) {
			throw new IllegalArgumentException("mid: 第一引数は整数を指定してください。: " + args[0]);
		}
		if (!StringUtils.isNumeric(args[1]) || Integer.parseInt(args[1]) < 0) {
			throw new IllegalArgumentException("mid: 第二引数は整数を指定してください。: " + args[1]);
		}
		int pos = Integer.parseInt(args[0]);
		int len = Integer.parseInt(args[1]);
		return StringUtils.mid(value, pos, len);
	}

}
