package jp.sourceforge.talisman.csvio.builder;

/*
 * $Id: AbstractCsvLineBuilder.java 4 2007-08-11 01:41:41Z tama3 $
 */

import java.util.List;

import jp.sourceforge.talisman.csvio.CsvIOSetting;
import jp.sourceforge.talisman.csvio.CsvLine;
import jp.sourceforge.talisman.csvio.CsvLineBuilder;

/**
 * 
 * @author tamada
 * @version $Revision: 4 $ $Date: 2007-08-11 10:41:41 +0900 (Sat, 11 Aug 2007) $
 */
abstract class AbstractCsvLineBuilder implements CsvLineBuilder{
    private CsvIOSetting setting;

    public AbstractCsvLineBuilder(){
        this(new CsvIOSetting());
    }

    public AbstractCsvLineBuilder(CsvIOSetting setting){
        this.setting = setting;
    }

    public CsvIOSetting getSetting(){
        return setting;
    }

    public void setSetting(CsvIOSetting setting){
        this.setting = setting;
    }

    public CsvLine buildCsvLine(String line){
        List<String> strings = splitToTokens(line);
    
        CsvLine csvline = new CsvLine();
        for(String string: strings){
            csvline.addValue(string);
        }
    
        return csvline;
    }

    protected abstract List<String> splitToTokens(String line);
}
