/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.io.File;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;

public class FileTransfer
extends ByteArrayTransfer {
    static FileTransfer _instance = new FileTransfer();
    static final String HFS = "hfs ";
    static final String FURL = "furl";
    static final int HFSID = FileTransfer.registerType("hfs ");
    static final int FURLID = FileTransfer.registerType("furl");

    FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] files = (String[])object;
        transferData.result = -1;
        byte[][] data = new byte[files.length][];
        int i = 0;
        while (i < data.length) {
            block19: {
                File file = new File(files[i]);
                boolean isDirectory = file.isDirectory();
                String fileName = files[i];
                char[] chars = new char[fileName.length()];
                fileName.getChars(0, chars.length, chars, 0);
                int cfstring = OS.CFStringCreateWithCharacters(0, chars, chars.length);
                if (cfstring == 0) {
                    return;
                }
                try {
                    int url = OS.CFURLCreateWithFileSystemPath(0, cfstring, 0, isDirectory);
                    if (url == 0) {
                        return;
                    }
                    try {
                        if (transferData.type == HFSID) {
                            byte[] fsRef = new byte[80];
                            if (!OS.CFURLGetFSRef(url, fsRef)) {
                                return;
                            }
                            byte[] fsSpec = new byte[70];
                            if (OS.FSGetCatalogInfo(fsRef, 0, null, null, fsSpec, null) != 0) {
                                return;
                            }
                            byte[] hfsflavor = new byte[10 + fsSpec.length];
                            byte[] finfo = new byte[16];
                            OS.FSpGetFInfo(fsSpec, finfo);
                            System.arraycopy(finfo, 0, hfsflavor, 0, 10);
                            System.arraycopy(fsSpec, 0, hfsflavor, 10, fsSpec.length);
                            data[i] = hfsflavor;
                        }
                        if (transferData.type != FURLID) break block19;
                        int encoding = OS.CFStringGetSystemEncoding();
                        int theData = OS.CFURLCreateData(0, url, encoding, true);
                        if (theData == 0) {
                            return;
                        }
                        try {
                            int length = OS.CFDataGetLength(theData);
                            byte[] buffer = new byte[length];
                            CFRange range = new CFRange();
                            range.length = length;
                            OS.CFDataGetBytes(theData, range, buffer);
                            data[i] = buffer;
                        }
                        finally {
                            OS.CFRelease(theData);
                        }
                    }
                    finally {
                        OS.CFRelease(url);
                        return;
                    }
                }
                finally {
                    OS.CFRelease(cfstring);
                }
            }
            ++i;
        }
        transferData.data = data;
        transferData.result = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData)) return null;
        if (transferData.data == null) {
            return null;
        }
        if (transferData.data.length == 0) {
            return null;
        }
        int count = transferData.data.length;
        String[] fileNames = new String[count];
        int i = 0;
        while (i < count) {
            int encoding;
            byte[] data = transferData.data[i];
            int url = 0;
            if (transferData.type == HFSID) {
                byte[] fsspec = new byte[data.length - 10];
                System.arraycopy(data, 10, fsspec, 0, fsspec.length);
                byte[] fsRef = new byte[80];
                if (OS.FSpMakeFSRef(fsspec, fsRef) != 0) {
                    return null;
                }
                url = OS.CFURLCreateFromFSRef(0, fsRef);
                if (url == 0) {
                    return null;
                }
            }
            if (transferData.type == FURLID && (url = OS.CFURLCreateWithBytes(0, data, data.length, encoding = 0x8000100, 0)) == 0) {
                return null;
            }
            try {
                int path = OS.CFURLCopyFileSystemPath(url, 0);
                if (path == 0) {
                    return null;
                }
                try {
                    int length = OS.CFStringGetLength(path);
                    if (length == 0) {
                        return null;
                    }
                    char[] buffer = new char[length];
                    CFRange range = new CFRange();
                    range.length = length;
                    OS.CFStringGetCharacters(path, range, buffer);
                    fileNames[i] = new String(buffer);
                }
                finally {
                    OS.CFRelease(path);
                    return null;
                }
            }
            finally {
                OS.CFRelease(url);
            }
            ++i;
        }
        return fileNames;
    }

    protected int[] getTypeIds() {
        return new int[]{FURLID, HFSID};
    }

    protected String[] getTypeNames() {
        return new String[]{FURL, HFS};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] strings = (String[])object;
        int i = 0;
        while (i < strings.length) {
            if (strings[i] == null || strings[i].length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

