/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.UAElementFactory;
import org.eclipse.help.internal.dynamic.FilterResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UAElement
implements IUAElement {
    private static final String ELEMENT_FILTER = "filter";
    private static final String ATTRIBUTE_FILTER = "filter";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";
    private static DocumentBuilder builder;
    private static Document document;
    public Element element;
    public IUAElement src;
    public UAElement parent;
    public UAElement[] children;

    public UAElement(Element element) {
        this.element = element;
    }

    public UAElement(String name) {
        this.element = UAElement.getDocument().createElement(name);
    }

    public UAElement(String name, IUAElement src) {
        this(name);
        UAElement sourceElement;
        String filter;
        this.src = src;
        if (src instanceof UAElement && (filter = (sourceElement = (UAElement)src).getAttribute("filter")) != null && filter.length() > 0) {
            this.setAttribute("filter", filter);
        }
    }

    public void appendChild(UAElement uaElementToAppend) {
        this.importElement(uaElementToAppend);
        this.element.appendChild(uaElementToAppend.element);
        uaElementToAppend.parent = this;
        this.children = null;
    }

    public void appendChildren(IUAElement[] children) {
        int i = 0;
        while (i < children.length) {
            this.appendChild(children[i] instanceof UAElement ? (UAElement)children[i] : UAElementFactory.newElement(children[i]));
            ++i;
        }
    }

    public String getAttribute(String name) {
        String value = this.element.getAttribute(name);
        if (value.length() > 0) {
            return value;
        }
        return null;
    }

    public IUAElement[] getChildren() {
        if (this.children == null) {
            if (this.element.hasChildNodes()) {
                ArrayList<UAElement> list = new ArrayList<UAElement>();
                Node node = this.element.getFirstChild();
                while (node != null) {
                    if (node.getNodeType() == 1) {
                        UAElement uaElement = UAElementFactory.newElement((Element)node);
                        uaElement.parent = this;
                        if (uaElement != null) {
                            list.add(uaElement);
                        }
                    }
                    node = node.getNextSibling();
                }
                this.children = list.toArray(new UAElement[list.size()]);
            } else {
                this.children = new UAElement[0];
            }
        }
        return this.children;
    }

    public Object getChildren(Class clazz) {
        IUAElement[] children = this.getChildren();
        if (children.length > 0) {
            ArrayList<IUAElement> list = new ArrayList<IUAElement>();
            int i = 0;
            while (i < children.length) {
                IUAElement child = children[i];
                if (clazz.isAssignableFrom(child.getClass())) {
                    list.add(child);
                }
                ++i;
            }
            return list.toArray((Object[])Array.newInstance(clazz, list.size()));
        }
        return Array.newInstance(clazz, 0);
    }

    public String getElementName() {
        return this.element.getNodeName();
    }

    public static Document getDocument() {
        if (document == null) {
            if (builder == null) {
                try {
                    builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    builder.setEntityResolver(new EntityResolver(){

                        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                            return new InputSource(new StringReader(""));
                        }
                    });
                }
                catch (ParserConfigurationException e) {
                    String msg = "Error creating document builder";
                    HelpPlugin.logError(msg, e);
                }
            }
            document = builder.newDocument();
        }
        return document;
    }

    public UAElement getParentElement() {
        return this.parent;
    }

    public void insertBefore(UAElement newChild, UAElement refChild) {
        this.importElement(newChild);
        this.element.insertBefore(newChild.element, refChild.element);
        newChild.parent = this;
        this.children = null;
    }

    public boolean isEnabled(IEvaluationContext context) {
        if (HelpSystem.isShared()) {
            return true;
        }
        if (this.src != null) {
            return this.src.isEnabled(context);
        }
        String filter = this.getAttribute("filter");
        if (filter != null) {
            return this.isEnabledByFilterAttribute(filter);
        }
        Node node = this.element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                String name = node.getNodeName();
                if ("enablement".equals(name)) {
                    return this.isEnabledByEnablementElement((Element)node, context);
                }
                if ("filter".equals(name) && !this.isEnabledByFilterElement((Element)node)) {
                    return false;
                }
            }
            node = node.getNextSibling();
        }
        return true;
    }

    public void removeChild(UAElement elementToRemove) {
        this.element.removeChild(elementToRemove.element);
        elementToRemove.parent = null;
        this.children = null;
    }

    public void setAttribute(String name, String value) {
        this.element.setAttribute(name, value);
    }

    private void importElement(UAElement uaElementToImport) {
        Element elementToImport = uaElementToImport.element;
        Document ownerDocument = this.element.getOwnerDocument();
        if (!ownerDocument.equals(elementToImport.getOwnerDocument())) {
            elementToImport = (Element)ownerDocument.importNode(elementToImport, true);
        }
        uaElementToImport.element = elementToImport;
    }

    private boolean isEnabledByEnablementElement(Element enablement, IEvaluationContext context) {
        try {
            Expression expression = ExpressionConverter.getDefault().perform(enablement);
            return expression.evaluate(context) == EvaluationResult.TRUE;
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    private boolean isEnabledByFilterAttribute(String filter) {
        return !FilterResolver.getInstance().isFiltered(filter);
    }

    private boolean isEnabledByFilterElement(Element filter) {
        String name = filter.getAttribute(ATTRIBUTE_NAME);
        String value = filter.getAttribute(ATTRIBUTE_VALUE);
        if (name.length() > 0 && value.length() > 0) {
            boolean not = false;
            if (value.startsWith("!")) {
                not = true;
                value = value.substring(1);
            }
            return !FilterResolver.getInstance().isFiltered(name, value, not);
        }
        return true;
    }
}

