/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.MessageHelper;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EclipseCommandProvider
implements CommandProvider {
    private BundleContext context;
    static /* synthetic */ Class class$0;

    public EclipseCommandProvider(BundleContext context) {
        this.context = context;
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer(512);
        help.append(EclipseAdaptorMsg.NEW_LINE);
        help.append("---");
        help.append(EclipseAdaptorMsg.ECLIPSE_CONSOLE_COMMANDS_HEADER);
        help.append("---");
        help.append(EclipseAdaptorMsg.NEW_LINE);
        help.append("\tdiag - " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_DIAG_COMMAND_DESCRIPTION);
        return help.toString();
    }

    private BundleDescription getBundleDescriptionFromToken(State state, String token) {
        try {
            long id = Long.parseLong(token);
            return state.getBundle(id);
        }
        catch (NumberFormatException numberFormatException) {
            BundleDescription[] allBundles = state.getBundles(token);
            if (allBundles.length > 0) {
                return allBundles[0];
            }
            return null;
        }
    }

    public void _diag(CommandInterpreter ci) throws Exception {
        ServiceReference platformAdminRef;
        String nextArg = ci.nextArgument();
        if (nextArg == null) {
            ci.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((platformAdminRef = this.context.getServiceReference(clazz.getName())) == null) {
            ci.print("  ");
            ci.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS_NO_PLATFORM_ADMIN_MESSAGE);
            return;
        }
        try {
            PlatformAdmin platformAdmin = (PlatformAdmin)this.context.getService(platformAdminRef);
            if (platformAdmin == null) {
                return;
            }
            State systemState = platformAdmin.getState(false);
            while (nextArg != null) {
                BundleDescription bundle = this.getBundleDescriptionFromToken(systemState, nextArg);
                if (bundle == null) {
                    ci.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_CANNOT_FIND_BUNDLE_ERROR, nextArg));
                    nextArg = ci.nextArgument();
                    continue;
                }
                ci.println(String.valueOf(bundle.getLocation()) + " [" + bundle.getBundleId() + "]");
                VersionConstraint[] unsatisfied = platformAdmin.getStateHelper().getUnsatisfiedConstraints(bundle);
                ResolverError[] resolverErrors = platformAdmin.getState(false).getResolverErrors(bundle);
                int i = 0;
                while (i < resolverErrors.length) {
                    if ((resolverErrors[i].getType() & 0x8007) == 0) {
                        ci.print("  ");
                        ci.println(resolverErrors[i].toString());
                    }
                    ++i;
                }
                i = 0;
                while (i < unsatisfied.length) {
                    ci.print("  ");
                    ci.println(MessageHelper.getResolutionFailureMessage(unsatisfied[i]));
                    ++i;
                }
                if (unsatisfied.length == 0 && resolverErrors.length == 0) {
                    ci.print("  ");
                    ci.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS);
                }
                nextArg = ci.nextArgument();
            }
        }
        finally {
            this.context.ungetService(platformAdminRef);
        }
    }
}

