/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse.permutate;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.famteam.synapse.SynapseParameter;
import org.famteam.synapse.SynapseSetupException;
import org.famteam.synapse.analyze.HTMLAnalyzeException;
import org.famteam.synapse.analyze.HTMLDocument;
import org.famteam.synapse.analyze.HTMLSourceManager;
import org.famteam.synapse.http.RequestWrapper;
import org.famteam.synapse.permutate.DynamicHTMLDocument;
import org.famteam.synapse.permutate.PermutatePageSourceException;
import org.famteam.synapse.permutate.PermutatePageSourceManager;
import org.famteam.synapse.permutate.inject.InjectPermutate;

public class DynamicHTMLDocumentManager {
    private static Logger logger = Logger.getLogger((String)"DppSetup");
    private static HashMap dynamic_documents_map;

    public static void setUp() throws SynapseSetupException, PermutatePageSourceException, HTMLAnalyzeException, IOException {
        dynamic_documents_map = new HashMap();
        if (SynapseParameter.isINITIAL_SETUP()) {
            List html_source_list = HTMLSourceManager.getHTMLSources();
            Iterator html_source_iterator = html_source_list.iterator();
            while (html_source_iterator.hasNext()) {
                HTMLDocument now_html_document = (HTMLDocument)html_source_iterator.next();
                List now_pps_list = PermutatePageSourceManager.getPermutatePageSources(now_html_document.getHtml_file_name());
                if (logger.isDebugEnabled()) {
                    StringBuffer log_message = new StringBuffer();
                    log_message.append("Get pps for ").append(now_html_document.getHtml_file_name()).append(" is ").append(now_pps_list).append(".");
                    logger.debug((Object)log_message);
                }
                DynamicHTMLDocument now_dynamic_html_document = InjectPermutate.injectPermutate(now_html_document, now_pps_list);
                dynamic_documents_map.put(now_html_document.getHtml_file_name(), now_dynamic_html_document);
                if (!logger.isDebugEnabled()) continue;
                StringBuffer log_message = new StringBuffer();
                log_message.append("Load dynamic_html_document[").append(now_html_document.getHtml_file_name()).append("]");
                logger.debug((Object)log_message);
            }
        }
    }

    protected static DynamicHTMLDocument getDynamicHTMLDocument(String page_name) throws SynapseSetupException, PermutatePageSourceException, HTMLAnalyzeException, IOException {
        if (dynamic_documents_map == null) {
            DynamicHTMLDocumentManager.setUp();
        }
        return (DynamicHTMLDocument)dynamic_documents_map.get(page_name);
    }

    public static String getPageSource(String page_name, RequestWrapper request_wrapper) throws SynapseSetupException, PermutatePageSourceException, HTMLAnalyzeException, IOException {
        HTMLDocument html_document;
        DynamicHTMLDocument dynamic_html_document = DynamicHTMLDocumentManager.getDynamicHTMLDocument(page_name);
        if (dynamic_html_document == null && (html_document = HTMLSourceManager.getHTMLDocument(page_name)) != null) {
            dynamic_html_document = InjectPermutate.injectPermutate(html_document, PermutatePageSourceManager.getPermutatePageSources(page_name));
            if (logger.isDebugEnabled()) {
                StringBuffer log_message = new StringBuffer();
                log_message.append("Load dynamic_html_document[").append(page_name).append("]");
                logger.debug((Object)log_message);
            }
            if (dynamic_html_document != null) {
                dynamic_documents_map.put(page_name, dynamic_html_document);
            }
        }
        return dynamic_html_document != null ? dynamic_html_document.generateHTMLSource(request_wrapper) : null;
    }
}

