/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse.junction;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.famteam.synapse.SynapseSetupException;
import org.famteam.synapse.http.RequestWrapper;
import org.famteam.synapse.junction.PageJunction;
import org.famteam.synapse.junction.PageJunctionClassLoader;
import org.famteam.synapse.junction.PageJunctionException;
import org.famteam.synapse.junction.PageJunctionList;
import org.famteam.synapse.junction.PageJunctionMap;
import org.famteam.synapse.junction.PageJunctionTarget;
import org.famteam.synapse.junction.PageJunctionTargetException;

public class PageJunctionManager {
    private static Logger logger = Logger.getLogger((String)"DppRun");
    private static Logger logger_ll = Logger.getLogger((String)"LoadLog");
    private static PageJunctionMap page_junction_map = null;

    public static void setupPageJunction() throws SynapseSetupException, PageJunctionException {
        page_junction_map = new PageJunctionMap();
        PageJunction[] all_page_junctions = PageJunctionClassLoader.loadPageJunctionClasses();
        int i = 0;
        while (i < all_page_junctions.length) {
            page_junction_map.put(all_page_junctions[i]);
            ++i;
        }
        PageJunctionManager.saveLog();
    }

    protected static PageJunctionList getPageJunctions(String html_file_name) throws SynapseSetupException, PageJunctionTargetException, PageJunctionException {
        if (page_junction_map == null) {
            PageJunctionManager.setupPageJunction();
        }
        return page_junction_map.getPageJunctions(html_file_name);
    }

    public static void doPageJunctions(String html_file_name, RequestWrapper request_wrapper) throws SynapseSetupException, PageJunctionTargetException, PageJunctionException {
        PageJunctionList page_junction_list = PageJunctionManager.getPageJunctions(html_file_name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Load PageJunctions [" + page_junction_list + "]."));
        }
        if (page_junction_list != null) {
            page_junction_list.doPageJunctions(request_wrapper);
        }
    }

    protected static PageJunctionMap getPageJunctionMap() throws SynapseSetupException, PageJunctionException {
        if (page_junction_map == null) {
            PageJunctionManager.setupPageJunction();
        }
        return page_junction_map;
    }

    private static void saveLog() {
        if (logger_ll.isDebugEnabled()) {
            logger_ll.debug((Object)"PJ Load log.\n");
            Iterator page_junction_keys = page_junction_map.getMap().keySet().iterator();
            while (page_junction_keys.hasNext()) {
                PageJunctionTarget now_target = (PageJunctionTarget)page_junction_keys.next();
                logger_ll.debug((Object)now_target.getTarget_pattern_string());
                PageJunctionList now_pj_list = page_junction_map.getPageJunctions(now_target);
                Iterator now_pj_list_ite = now_pj_list.getList().iterator();
                while (now_pj_list_ite.hasNext()) {
                    logger_ll.debug((Object)new StringBuffer().append(",").append(now_pj_list_ite.next().getClass().getName()).append("\n"));
                }
            }
            logger_ll.debug((Object)"\n");
        }
    }
}

