/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse.analyze;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.famteam.synapse.analyze.HTMLAnalyzeException;

public class TagSearcher {
    private Matcher matcher = null;
    private String html_source;
    private ParseInfo now_search_info = null;

    public TagSearcher(String html_source) {
        Pattern open_tag_pattern = Pattern.compile("<[^/!][^<>]*[^/]>");
        this.matcher = open_tag_pattern.matcher(html_source);
        this.html_source = html_source;
    }

    public boolean nextTag() {
        while (this.matcher.find()) {
            try {
                this.now_search_info = new ParseInfo();
                return true;
            }
            catch (HTMLAnalyzeException hTMLAnalyzeException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getTagName() {
        return this.now_search_info.getNowTagName();
    }

    public String getTagText() {
        return this.now_search_info.getNowTagText();
    }

    public String getNowBeforeText() {
        return this.html_source.substring(0, this.now_search_info.getOpenTagStartIndex());
    }

    public String getNowAfterText() throws HTMLAnalyzeException {
        return this.html_source.substring(this.now_search_info.getCloseTagEndIndex());
    }

    public String getNowInnerText() throws HTMLAnalyzeException {
        return this.html_source.substring(this.now_search_info.getOpenTagEndIndex(), this.now_search_info.getCloseTagStartIndex());
    }

    class ParseInfo {
        private String now_tag_name;
        private String now_tag_text;
        private int now_close_tag_start_index = -1;
        private int now_close_tag_end_index = -1;

        public ParseInfo() throws HTMLAnalyzeException {
            this.now_tag_text = TagSearcher.this.html_source.substring(TagSearcher.this.matcher.start() + 1, TagSearcher.this.matcher.end() - 1);
            this.now_tag_name = this.now_tag_text.split(" ")[0];
            this.now_close_tag_start_index = this.getCloseTagStartIndex();
            this.now_close_tag_end_index = this.getCloseTagEndIndex();
        }

        public int getOpenTagStartIndex() {
            return TagSearcher.this.matcher.start();
        }

        public int getOpenTagEndIndex() {
            return TagSearcher.this.matcher.end();
        }

        public String getNowTagName() {
            return this.now_tag_name;
        }

        public String getNowTagText() {
            return this.now_tag_text;
        }

        public int getCloseTagStartIndex() throws HTMLAnalyzeException {
            if (this.now_close_tag_start_index == -1) {
                this.setupCloseTagInfo();
            }
            return this.now_close_tag_start_index;
        }

        public int getCloseTagEndIndex() throws HTMLAnalyzeException {
            if (this.now_close_tag_end_index == -1) {
                this.setupCloseTagInfo();
            }
            return this.now_close_tag_end_index;
        }

        private void setupCloseTagInfo() throws HTMLAnalyzeException {
            int now_close_tag_index;
            int now_same_tag_count = 0;
            int now_scan_index = this.getOpenTagEndIndex();
            Pattern now_pattern = Pattern.compile("<" + this.getNowTagName() + "(\\s.*?)?>");
            Matcher now_matcher = now_pattern.matcher(TagSearcher.this.html_source);
            while (true) {
                now_matcher.reset();
                int now_open_tag_index = now_matcher.find(now_scan_index) ? now_matcher.start() : -1;
                now_close_tag_index = TagSearcher.this.html_source.indexOf("</" + this.now_tag_name + ">", now_scan_index);
                if (now_close_tag_index == -1) {
                    throw new HTMLAnalyzeException();
                }
                if (now_open_tag_index == -1 || now_close_tag_index < now_open_tag_index) {
                    if (now_same_tag_count == 0) break;
                    --now_same_tag_count;
                    now_scan_index = now_close_tag_index + this.getNowCloseTagLength();
                    continue;
                }
                if (now_open_tag_index >= now_close_tag_index) continue;
                ++now_same_tag_count;
                now_scan_index = now_matcher.end();
            }
            this.setCloseTagInfo(now_close_tag_index);
        }

        private void setCloseTagInfo(int searche_result_close_tag_start_index) {
            this.now_close_tag_start_index = searche_result_close_tag_start_index;
            this.now_close_tag_end_index = this.now_close_tag_start_index + this.now_tag_name.length() + 3;
        }

        private int getNowCloseTagLength() {
            return this.now_tag_name.length() + 3;
        }
    }
}

