/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse.analyze;

import org.famteam.synapse.analyze.HTMLAnalyzeException;
import org.famteam.synapse.analyze.HTMLBlockTag;
import org.famteam.synapse.analyze.HTMLDocument;
import org.famteam.synapse.analyze.HTMLText;
import org.famteam.synapse.analyze.TagSearcher;

public class HTMLSourceAnalyzer {
    public static HTMLDocument analyzeHTMLSource(String html_source, String page_name) throws HTMLAnalyzeException {
        HTMLDocument html_document = new HTMLDocument();
        html_document.setHtml_file_name(page_name);
        TagSearcher tag_searcher = new TagSearcher(html_source);
        if (tag_searcher.nextTag()) {
            html_document.setDoctype_string(tag_searcher.getNowBeforeText());
            HTMLBlockTag block_tag = new HTMLBlockTag();
            block_tag.setTag_name(tag_searcher.getTagName());
            block_tag.setTag_text(tag_searcher.getTagText());
            html_document.setHtml_block_tag(block_tag);
            HTMLSourceAnalyzer.analyzeHTMLSourceLoop(tag_searcher.getNowInnerText(), block_tag);
            return html_document;
        }
        return null;
    }

    private static void analyzeHTMLSourceLoop(String html_source, HTMLBlockTag parent_block_tag) throws HTMLAnalyzeException {
        TagSearcher tag_searcher = new TagSearcher(html_source);
        if (tag_searcher.nextTag()) {
            HTMLBlockTag block_tag = new HTMLBlockTag();
            block_tag.setTag_name(tag_searcher.getTagName());
            block_tag.setTag_text(tag_searcher.getTagText());
            HTMLSourceAnalyzer.analyzeHTMLSourceLoop(tag_searcher.getNowBeforeText(), parent_block_tag);
            HTMLSourceAnalyzer.analyzeHTMLSourceLoop(tag_searcher.getNowInnerText(), block_tag);
            parent_block_tag.addChild(block_tag);
            HTMLSourceAnalyzer.analyzeHTMLSourceLoop(tag_searcher.getNowAfterText(), parent_block_tag);
        } else {
            parent_block_tag.addChild(new HTMLText(html_source));
        }
    }
}

