/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse;

import java.io.BufferedWriter;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.famteam.synapse.GeneratePage;
import org.famteam.synapse.IRequestInterceptor;
import org.famteam.synapse.SynapseFileObservar;
import org.famteam.synapse.SynapseInterceptorException;
import org.famteam.synapse.SynapseParameter;
import org.famteam.synapse.SynapseSetupException;
import org.famteam.synapse.analyze.HTMLAnalyzeException;
import org.famteam.synapse.http.CookieDataManager;
import org.famteam.synapse.http.FormDataException;
import org.famteam.synapse.http.FormDataMaker;
import org.famteam.synapse.http.RequestWrapper;
import org.famteam.synapse.http.ServerInfoManager;
import org.famteam.synapse.http.SessionDataManager;
import org.famteam.synapse.junction.PageJunctionException;
import org.famteam.synapse.junction.PageJunctionTargetException;
import org.famteam.synapse.permutate.PermutatePageSourceException;
import org.famteam.tools.parameter.ParameterFileNotFoundExeption;

public class SynapseControllerServlet
extends HttpServlet {
    private static final Logger setup_logger = Logger.getLogger((String)"DppSetup");
    private static final Logger run_logger = Logger.getLogger((String)"DppRun");
    private static final long serialVersionUID = -6917819331491870418L;
    private static IRequestInterceptor start_interceptor;
    private static IRequestInterceptor end_interceptor;
    private static IRequestInterceptor destroy_interceptor;

    public void init() throws ServletException {
        try {
            SynapseParameter.setup(String.valueOf(this.getServletContext().getRealPath("/")) + "WEB-INF/classes");
        }
        catch (ParameterFileNotFoundExeption e) {
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SynapseSetupException e) {
            throw new ServletException((Throwable)e);
        }
        if (SynapseParameter.isOBSERVER_FLAG()) {
            try {
                SynapseFileObservar.start();
            }
            catch (SynapseSetupException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (SynapseParameter.getSTART_INTERCEPTOR_CLASS() != null || SynapseParameter.getSTART_INTERCEPTOR_CLASS().equals("")) {
            start_interceptor = this.getRequestInterceptor(SynapseParameter.getSTART_INTERCEPTOR_CLASS());
        }
        if (SynapseParameter.getEND_INTERCEPTOR_CLASS() != null || SynapseParameter.getEND_INTERCEPTOR_CLASS().equals("")) {
            end_interceptor = this.getRequestInterceptor(SynapseParameter.getEND_INTERCEPTOR_CLASS());
        }
        if (SynapseParameter.getEND_INTERCEPTOR_CLASS() != null || SynapseParameter.getEND_INTERCEPTOR_CLASS().equals("")) {
            destroy_interceptor = this.getRequestInterceptor(SynapseParameter.getDESTROY_INTERCEPTOR_CLASS());
        }
    }

    private IRequestInterceptor getRequestInterceptor(String interceptor_class_name) throws ServletException {
        IRequestInterceptor return_interceptor;
        if (interceptor_class_name != null || interceptor_class_name.equals("")) {
            try {
                return_interceptor = (IRequestInterceptor)Class.forName(interceptor_class_name).newInstance();
            }
            catch (InstantiationException e) {
                setup_logger.error((Object)new StringBuffer("Load interceptor error [").append(interceptor_class_name).append("]."), (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                setup_logger.error((Object)new StringBuffer("Load interceptor error [").append(interceptor_class_name).append("]."), (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                setup_logger.error((Object)new StringBuffer("Load interceptor error [").append(interceptor_class_name).append("]."), (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        } else {
            return_interceptor = null;
        }
        return return_interceptor;
    }

    public void destroy() {
        super.destroy();
        if (destroy_interceptor != null) {
            try {
                destroy_interceptor.doInterceptor(null, null);
            }
            catch (SynapseInterceptorException e) {
                setup_logger.error((Object)"Error in destroy.", (Throwable)e);
            }
        }
        SynapseFileObservar.stop();
    }

    protected void service(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        String result_html;
        if (start_interceptor != null) {
            try {
                start_interceptor.doInterceptor(arg0, arg1);
            }
            catch (SynapseInterceptorException e1) {
                throw new ServletException((Throwable)e1);
            }
        }
        RequestWrapper request_wrapper = new RequestWrapper();
        arg1.setCharacterEncoding(SynapseParameter.getFORM_DATA_ENCODING());
        try {
            this.setupRequestWrapper(request_wrapper, arg0, arg1);
        }
        catch (FormDataException e) {
            run_logger.error((Object)"Setup RequestWrapper error.", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        try {
            try {
                result_html = GeneratePage.getPageSource(this.getRequestString(arg0), request_wrapper);
                this.reflectRequestWrapper(request_wrapper, arg0, arg1);
            }
            catch (SynapseSetupException e) {
                run_logger.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            catch (PageJunctionTargetException e) {
                run_logger.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            catch (PageJunctionException e) {
                run_logger.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            catch (PermutatePageSourceException e) {
                run_logger.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            catch (HTMLAnalyzeException e) {
                run_logger.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            catch (Throwable e) {
                run_logger.error((Object)e);
                throw new ServletException(e);
            }
        }
        finally {
            if (end_interceptor != null) {
                try {
                    end_interceptor.doInterceptor(arg0, arg1);
                }
                catch (SynapseInterceptorException e1) {
                    throw new ServletException((Throwable)e1);
                }
            }
        }
        BufferedWriter html_writer = new BufferedWriter(arg1.getWriter());
        html_writer.write(result_html != null ? result_html : "");
        html_writer.close();
    }

    private void setupRequestWrapper(RequestWrapper request_wrapper, HttpServletRequest request, HttpServletResponse response) throws FormDataException {
        request_wrapper.setFormData(FormDataMaker.getFormData(request));
        request_wrapper.setSessionData(SessionDataManager.getSessionData(request));
        request_wrapper.setCookieData(CookieDataManager.getCookieData(request));
        request_wrapper.setServerInfo(ServerInfoManager.getServerInfo(this, request));
    }

    private void reflectRequestWrapper(RequestWrapper request_wrapper, HttpServletRequest request, HttpServletResponse response) {
        SessionDataManager.setSessionData(request, request_wrapper.getSessionData());
        CookieDataManager.setCookieData(response, request_wrapper.getCookieData());
    }

    private String getRequestString(HttpServletRequest request) {
        String request_uri = request.getRequestURI();
        return request_uri.substring(request_uri.indexOf("dpp/") + 3);
    }
}

