<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementCheckbox.php,v 1.11 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * åܥåեǥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementCheckbox.php,v 1.11 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FormElementCheckbox extends SyL_FormElement
{
    /**
     * ٥ID̾
     *
     * @access private
     * @var string
     */
    var $label = '_chk';
    /**
     * Ǵ֤ζڤʸ
     *
     * @access private
     * @var string
     */
    var $separator = "&nbsp;\r\n";

    /**
     * ̾ʣˤ
     *
     * @access public
     * @return string ̾
     */
    function getNames()
    {
        return $this->getName() . '[]';
    }

    /**
     * ͤ򥻥åȤ
     *
     * @access public
     * @param mixed 
     */
    function setValue($value)
    {
        if (($value === '') || ($value === null)) {
            $this->value = array();
        } else if (!is_array($value)) {
            $this->value = array($value);
        } else {
            $this->value = $value;
        }
    }

    /**
     * Ǵ֤ζڤʸ򥻥å
     *
     * @access public
     * @param string Ǵ֤ζڤʸ
     */
    function setSeparator($separetor)
    {
        $this->separator = $separetor;
    }

    /**
     * եHTML
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlTag()
    {
        $this->setAttribute($this->getNames(), 'name');
        $this->setAttribute($this->type, 'type');

        $i = 0;
        $options = array();
        foreach ($this->options as $key => $value) {
            $id = $this->label . '_' . $this->getName() . '_' . $i;
            $this->setAttribute($id, 'id');
            $this->setAttribute($key, 'value');
            $checked = in_array((string)$key, $this->value, true) ? 'checked' : '';

            $options[] = '<input ' . $this->getAttributes() . ' ' . $checked . ' /><label for="' . $id . '">' . $this->encode($value) . '</label>';
            $i++;
        }

        return implode($this->separator, $options);
    }

    /**
     * եHTML
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlView()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if (in_array((string)$key, $this->value, true)) {
                $options[] = $this->encode($value) . $this->getHtmlHidden($this->getNames(), $key);
            }
        }
  
        return implode($this->separator, $options);
    }

    /**
     * JavaScriptϥå
     *
     * @access public
     * @param string ե̾
     * @return string JavaScriptϥå
     */
    function getJs($formname)
    {
        if (is_object($this->validators)) {
            $element = $this->getNames();
            $func    = "check_{$formname}_" . $this->getName() . "(form, errors)";
            $js      = $this->validators->getJs($this->getDisplayName());
            $js = <<< JAVASCRIPT_CODE
function {$func} {
  var validation    = new SyL_Validation(form);
  var element_name  = "{$element}";
  var error_message = '';

{$js}

  if (error_message) {
    switch (typeof(errors)) {
    case 'object':
      errors.setErrorMessage(element_name, error_message);
      break;
    case 'string':
      document.getElementById(errors).innerHTML = error_message;
      break;
    }
  }
}

JAVASCRIPT_CODE;
            return array($func, $js);
        } else {
            return array();
        }
    }
}

?>
