<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriter.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML饹
 */
require_once dirname(__FILE__) . '/../SyL_XmlWriter.php';

/**
 * RSS 饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriter.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRssWriter extends SyL_XmlWriter
{
    /**
     * RSSͥ
     * 
     * @access protected
     * @var array
     */
    var $channel = array();
    /**
     * 
     * 
     * @access protected
     * @var array
     */
    var $image = array();
    /**
     * ƥ
     * 
     * @access protected
     * @var array
     */
    var $textinput = array();
    /**
     * RSͥ°
     * 
     * @access protected
     * @var array
     */
    var $channel_attr = array();
    /**
     * RSSǡ
     * 
     * @access protected
     * @var array
     */
    var $items = array();
    /**
     * RSSǡ°
     * 
     * @access protected
     * @var array
     */
    var $items_attribute = array();

    /**
     * RSS
     *
     * @access public
     */
    function &getObject($version='2.0')
    {
        $classname = 'SyL_XmlRssWriter' . str_replace('.', '_', $version);
        $include_file = dirname(__FILE__) . '/Writer/' . $classname . '.php';
        if (!file_exists($include_file)) {
            trigger_error("[SyL error] Rss version not supported ({$version})", E_USER_ERROR);
        }
        include_once $include_file;
        $writer =& new $classname();
        return $writer;
    }

    /**
     * ͥǤ򥻥åȤ
     * 
     * @access public
     * @param string ̾
     * @param string 
     * @param array °
     */
    function setChannel($name, $value, $attributes=array())
    {
        $this->channel[] = array($name, $value);
        if (count($attributes) > 0) {
            $i = count($this->channel) - 1;
            $this->channel_attr[$i] = $attributes;
        }
    }

    /**
     * Ǥ򥻥åȤ
     * 
     * @access public
     * @param array 
     */
    function setImage($value)
    {
        if (!is_array($value)) {
            trigger_error("[SyL error] Invalid args of setImage method", E_USER_ERROR);
        }
        $this->image = $value;
    }

    /**
     * ƥǤ򥻥åȤ
     * 
     * @access public
     * @param array ƥ
     */
    function setTextInput($value)
    {
        if (!is_array($value)) {
            trigger_error("[SyL error] Invalid args of setTextInput method", E_USER_ERROR);
        }
        $this->textinput = $value;
    }

    /**
     * ܤ򥻥åȤ
     * 
     * @access public
     * @param string ̾
     * @param string 
     * @param array °
     */
    function addItem($values, $attributes=array())
    {
        $this->items[] = $values;
        if (count($attributes) > 0) {
            $this->items_attribute[count($this->items)-1] = $attributes;
        }
    }

    /**
     * RSS
     * 
     * @access public
     * @return string RSSǡ
     */
    function create($parser_check=false)
    {
        $this->isEol(true);
        $this->addDeclaration();
        // XML
        $this->createXml();
        return parent::create($parser_check);
    }

    /**
     * RSS XML
     * 
     * @access public
     */
    function createXml()
    {
    }

    /**
     * RSSǤƵŪ˺
     * 
     * @access protected
     * @param string ̾
     * @param string 
     */
    function createRecursiveElements($name, $value='', $attributes=array())
    {
        if (is_array($value)) {
            $this->addStartElement($name);
            foreach ($value as $name1 => $value1) {
                $this->createRecursiveElements($name1, $value1, (isset($attributes[$name1]) ? $attributes[$name1] : array()));
            }
            $this->addEndElement();
        } else {
            $this->addElement($name, $attributes, $value);
        }
    }

    /**
     * եޥåȤѴ
     *
     * @access protected
     * @param string Ѵ
     * @return string Ѵ
     */
    function convertDateTime($datetime)
    {
        return $datetime;
    }
}

?>
