<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Loader.php,v 1.3 2007/07/29 08:55:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * PHPեɥ饹
 *
 * SyL_DB.php
 *   => SyL_Loader::lib('DB');
 * DB/SyL_DBSqlBuilder.php
 *   => SyL_Loader::lib('DB.SqlBuilder');
 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Loader.php,v 1.3 2007/07/29 08:55:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Loader
{
    /**
     * 饤֥ǥ쥯ȥ꤫PHPեɤ
     * 
     * @static
     * @access public
     * @param string ɥե
     * @param bool 顼٥ȥե饰
     * @return mixed include_once
     */
    function lib($path, $trigger=true)
    {
        $classname = __CLASS__;

        $tmp_path = call_user_func(array($classname, 'convertPath'), $path);
        // ץꥱ饤֥ǥ쥯ȥ
        $base1 = SYL_PROJECT_LIB_DIR . $tmp_path;
        if (is_file($base1)) {
            return call_user_func(array($classname, 'load'), $base1);
        }

        $tmp_path = call_user_func(array($classname, 'convertPathSyL'), $path);
        // ɸ饤֥ǥ쥯ȥSyLѥѥ
        $base2 = SYL_INCLUDE_DIR . "/lib" . $tmp_path;
        if (is_file($base2)) {
            return call_user_func(array($classname, 'load'), $base2);
        }

        if ($trigger) {
            trigger_error("[SyL error] Library file not found ({$base1} or {$base2})", E_USER_ERROR);
        } else {
            return false;
        }
    }

    /**
     * ե졼ǥ쥯ȥ꤫PHPեɤ
     * 
     * @static
     * @access public
     * @param string ɥե
     * @param bool 顼٥ȥե饰
     * @return mixed include_once
     */
    function fw($path, $trigger=true)
    {
        $classname = __CLASS__;

        $tmp_path = call_user_func(array($classname, 'convertPathSyL'), $path);
        $base1 = SYL_INCLUDE_DIR . "/framework" . $tmp_path;
        if (is_file($base1)) {
            return call_user_func(array($classname, 'load'), $base1);
        }

        if ($trigger) {
            trigger_error("[SyL error] Framework file not found ({$base1})", E_USER_ERROR);
        } else {
            return false;
        }
    }

    /**
     * ǥ쥯ȥ꤫PHPեɤ
     * 
     * @static
     * @access public
     * @param string ɥե
     * @return mixed include_once
     */
    function load($path)
    {
        if (is_readable($path)) {
            return include_once $path;
        } else {
            trigger_error("[SyL error] file not readable ({$path})", E_USER_ERROR);
        }
    }

    /**
     * ѥѴ
     * 
     * @static
     * @access public
     * @param string ѥ
     * @return string Ѵѥ
     */
    function convertPath($path, $ext='php')
    {
        return '/' . implode('/', array_map('ucfirst', explode('.', $path))) . '.' . $ext;
    }

    /**
     * SyL饤֥Ѥ˥ѥѴ
     * 
     * @static
     * @access public
     * @param string ѥ
     * @return string Ѵѥ
     */
    function convertPathSyL($path)
    {
        $path      = array_map('ucfirst', explode('.', $path));
        $classname = 'SyL_' . implode('', $path);
        array_pop($path); // ե
        $path = implode('/', $path);
        if ($path == '') {
            return "/{$classname}.php";
        } else {
            return "/{$path}/{$classname}.php";
        }
    }

    /**
     * ѥ饯饹̾
     * 
     * @static
     * @access public
     * @param string ѥ
     * @param bool 󥯥롼ɥե饰
     * @return string 饹̾
     */
    function convertClass($path, $load=false)
    {
        if ($load) {
            call_user_func(array(__CLASS__, 'lib'), $path);
        }
        return implode('', array_map('ucfirst', explode('.', $path)));
    }

    /**
     * ѥSyL饤֥ꥯ饹̾
     * 
     * @static
     * @access public
     * @param string ѥ
     * @return string 饹̾
     */
    function convertClassSyL($path)
    {
        return 'SyL_' . call_user_func(array(__CLASS__, 'convertClass'), $path);
    }
}

?>
