<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML꡼饹
 */
require_once dirname(__FILE__) . '/../SyL_XmlReader.php';

/**
 * RSS꡼饹
 *
 *  dateѴ
 *   1.0      - 2007-03-14T19:44:00+09:00       -> 2007/03/14 19:44:00
 *   0.91 2.0 - Mon, 12 Mar 2007 00:00:00 +0900 -> 2007/03/12 00:00:00
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRssReader extends SyL_XmlReader
{
    /**
     * RSSС
     * 
     * @access protected
     * @var string
     */
    var $version = '';
    /**
     * RSSͥ
     * 
     * @access protected
     * @var array
     */
    var $channel = array();
    /**
     * RSSͥ°
     * 
     * @access protected
     * @var array
     */
    var $channel_attr = array();
    /**
     * RSSǡ
     * 
     * @access protected
     * @var array
     */
    var $items = array();
    /**
     * RSSǡ°
     * 
     * @access protected
     * @var array
     */
    var $items_attr = array();
    /**
     * Ȥιܿ
     * 
     * @access protected
     * @var int
     */
    var $item_count = 0;

    /**
     * RSS󥹥󥹤
     *
     * @access public
     * @param string RSS XMLǡ
     * @param string RSS С
     * @return object RSS꡼֥
     */
    function &getObject(&$data, $version='')
    {
        // С󤬻ꤵʤϼưȽ
        if (!$version) {
            $tmp = substr($data, 0, 200); // ޤƬʸ
            if (preg_match('/<rss[^>]+version=\"([^\"]+)\"[^>]*>/i', $tmp, $matches)) {
                $version = $matches[1];
            } else if (strpos($tmp, '<rdf:RDF') !== false) {
                $version = '1.0';
            } else if (strpos($tmp, '<feed') !== false) {
                $version = 'Atom1.0';
            } else {
                trigger_error("[SyL error] Rss version undefined", E_USER_ERROR);
            }
        } else {
            $version = ucfirst($version);
        }

        $this->version = $version;

        // Ƭ100ХܤޤǤ˥󥳡ǥ󥰤ä
        $original_encode = '';
        if (preg_match ('/<\?xml(.*)encoding=\"(.+)\"(.*)\?>/i', substr(ltrim($data), 0, 100), $matches)) {
            $original_encode = $matches[2];
        }

        $classname = 'SyL_XmlRssReader' . str_replace('.', '_', $version);
        $include_file = dirname(__FILE__) . '/Reader/' . $classname . '.php';
        if (!file_exists($include_file)) {
            trigger_error("[SyL error] Rss version not supported ({$version})", E_USER_ERROR);
        }
        include_once $include_file;
        $reader =& new $classname();
        if ($original_encode) {
            $reader->setXmlEncode($original_encode);
        }
        $reader->setData($data);
        return $reader;
    }

    /**
     * ꤷͥ
     *
     * @access public
     * @return mixed ꤷͥ
     */
    function getChannel($name, $subname=null)
    {
        if ($subname) {
            return (isset($this->channel[$name][$subname]) ? $this->channel[$name][$subname] : null);
        } else {
            return (isset($this->channel[$name]) ? $this->channel[$name] : null);
        }
    }

    /**
     * ꤷͥ°
     *
     * @access public
     * @param string ̾
     * @param string ǥ̾
     * @return array ꤷͥ°
     */
    function getChannelAttr($name, $subname=null)
    {
        if ($subname) {
            return (isset($this->channel_attr[$name][$subname]) ? $this->channel_attr[$name][$subname] : null);
        } else {
            return (isset($this->channel_attr[$name]) ? $this->channel_attr[$name] : null);
        }
    }

    /**
     * ۿƼ
     *
     * @access public
     * @return array ۿ
     */
    function getItems()
    {
        return $this->items;
    }

    /**
     * ۿ
     *
     * @access public
     * @return int ۿ
     */
    function getItemCount()
    {
        return $this->item_count;
    }

    /**
     * ۿ°
     *
     * @access public
     * @param int 
     * @param string ̾
     * @param string ǥ̾
     * @return array ۿ°
     */
    function getItemAttr($index, $name, $subname=null)
    {
        if ($subname) {
            return (isset($this->items_attr[$index][$name][$subname]) ? $this->items_attr[$index][$name][$subname] : null);
        } else {
            return (isset($this->items_attr[$index][$name]) ? $this->items_attr[$index][$name] : null);
        }
    }

    /**
     * եޥåȤѴ
     *
     * @access public
     * @param string Ѵ
     * @return string Ѵ
     */
    function convertDateTime($datetime)
    {
        $timestamp = @strtotime($datetime);
        if ($timestamp) {
            return date('Y/m/d H:i:s', $timestamp);
        } else {
            return $datetime;
        }
    }
}

?>
