<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (c) 2006-2007 k.watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL.php,v 1.28 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * С
 */
define('SYL_VERSION', '0.12.0');

/**
 * ١ǥ쥯ȥ
 */
define('SYL_DIR', dirname(__FILE__));
define('SYL_INCLUDE_DIR', SYL_DIR . '/include');

/**
 * ǥХå٥
 */
define('SYL_LOG_NONE',     0);
define('SYL_LOG_ERROR',    1); // = E_ERROR
define('SYL_LOG_WARN',     2); // = E_WARNING
define('SYL_LOG_NOTICE',   8); // = E_NOTICE
define('SYL_LOG_INFO',  1024); // = E_USER_NOTICE 
define('SYL_LOG_DEBUG', 2047); // = E_ALL

/**
 * 󥳡
 */
define('SYL_ENCODE_INTERNAL', 'EUC-JP');
define('SYL_ENCODE_MAIL',     'ISO-2022-JP');
define('SYL_ENCODE_AJAX',     'UTF-8');
define('SYL_ENCODE_XML',      'UTF-8');
define('SYL_ENCODE_XMLRPC',   'UTF-8');

/**
 * ॾPHP 5.1ʾ
 */
if (version_compare(PHP_VERSION, '5.1.0', '>=') && !ini_get('date.timezone')) {
    date_default_timezone_set('Asia/Tokyo');
}

/**
 * PHPƥ२顼¸
 * ȤǥƤʤ硢¸
 */
if (!ini_get('log_errors')) {
    $_log = SYL_DIR . '/var/syslogs/phperror_' . date('Ymd') . '.log';
    if (is_writable(dirname($_log))) {
        ini_set('log_errors', true);
        ini_set('error_log', $_log);
    }
}

// ȥɤ߹
require_once SYL_INCLUDE_DIR . '/framework/SyL_Controller.php';

?>
