<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlReader.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLѡ饹
 */
require_once 'SyL_XmlParser.php';

/**
 * XML꡼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlReader.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlReader extends SyL_XmlParser
{
    /**
     * XMLΥγ
     *
     * @access private
     * @var int
     */
    var $depth = 0;
    /**
     * ͭȳ
     *
     * @access private
     * @var int
     */
    var $depth_row = 0;
    /**
     * XMLΥѥ
     *
     * @access private
     * @var array
     */
    var $current_path = array();
    /**
     * XMLΥ°
     *
     * @access private
     * @var array
     */
    var $attribute = array();
    /**
     * XMLΥ
     *
     * @access private
     * @var string
     */
    var $text = null;
    /**
     * ɽʸ
     *
     * @access private
     * @var string
     */
    var $client_encode = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_XmlReader()
    {
        $this->client_encode = mb_internal_encoding();
    }

    /**
     * ץȤΥ󥳡ɤ򥻥å
     *
     * @access public
     * @param string 󥳡̾
     */
    function setClientEncode($client_encode)
    {
        $this->client_encode = $client_encode;
    }

    /**
     * ȳϤμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ̾
     * @param array Ȥ°
     */
    function startElement(&$parser, $name, $attr)
    {
        // ʸѴ
        $name = $this->convertEencoding($name);
        // °ͼ
        $attribute = array();
        foreach ($attr as $key => $value) {
            $key   = $this->convertEencoding($key);
            $value = $this->convertEencoding($value);
            $attribute[$key] = $value;
        }

//echo "PATH - " . $name . " - " . $this->depth . " - " .$this->depth_row . "<br>";

        // ¸ѥ1ɲ
        $this->current_path[$this->depth] = $name;
        // ¸°1ɲ
        $this->attribute[$this->depth] = $attribute;
        // 1ɲ
        $this->depth++;
    }

    /**
     * Ƚλμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ̾
     */
    function endElement(&$parser, $name)
    {
//echo "EE - " . $this->depth . " - " . $this->depth_row . " - " . $this->getCurrentPath() . "\n";
        if ($this->text !== null) {
            $this->getElement($this->getCurrentPath(), $this->attribute[count($this->attribute)-1], $this->text);
        }
        // ޤǤγؤǼ
        $cnt = count($this->attribute);
        $this->getDepthElements($cnt);

        // 1غ
        $this->depth--;
        $this->depth_row--;
        // ¸ѥ1غ
        unset($this->current_path[$this->depth]);
        // ¸°1غ
        unset($this->attribute[$this->depth]);
        // Text
        $this->text = null;
    }

    /**
     * 饯Ȥμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ʸ
     */
    function characters(&$parser, $text)
    {
        if (trim($text) !== '') {
            if ($this->text === null) {
                // ޤǤγؤǲذʳǼ
                $cnt = count($this->attribute) - 1;
//echo $this->depth . " - " . $this->depth_row . " - " . $this->getCurrentPath() . " '$text' - $cnt \n";
                $this->getDepthElements($cnt);
                $this->depth_row++;
            }
            // ʸѴ
            $this->text .= $this->convertEencoding($text);
        }
    }

    /**
     * Ǽ
     *
     * @access abstract
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text) {}

    /**
     * ޤǤγؤǼ
     *
     * @access private
     * @param int ؿ
     */
    function getDepthElements($cnt)
    {
        $tmp_path = '';
        for ($i=0; $i<$cnt; $i++) {
            $tmp_path .= '/' . $this->current_path[$i];
            if ($this->depth_row <= $i) {
                $this->getElement($tmp_path, $this->attribute[$i], null);
                $this->depth_row++;
            }
        }
    }

    /**
     * XMLΥѥ
     *
     * @access public
     * @return string XMLΥѥ
     */
    function getCurrentPath()
    {
        return '/' . implode('/', $this->current_path);
    }

    /**
     * 󥳡ǥѴ
     *
     * @access public
     * @param string 󥳡ǥѴѴʸ
     * @return string 󥳡ǥѴѴʸ
     */
    function convertEencoding($value)
    {
        if ($this->client_encode != $this->xml_encode) {
            return mb_convert_encoding($value, $this->client_encode, $this->xml_encode);
        } else {
            return $value;
        }
    }
}

?>
