<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Auth.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ǧڥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Auth.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Auth
{
    /**
     * å󥪥֥
     * 
     * @access private
     * @var object
     */
    var $session = null;
    /**
     * å̾
     * 
     * @access private
     * @var string
     */
    var $session_name = 'syl_auth_session';
    /**
     * 桼IDѥ᡼̾
     * 
     * @access private
     * @var string
     */
    var $username = 'username';
    /**
     * ѥɥѥ᡼̾
     * 
     * @access private
     * @var string
     */
    var $password = 'passwd';
    /**
     * ѥǧڤŹ沽ϥå岽ƹԤ
     *
     * ξϡʿʸ
     * 
     * @access private
     * @var string
     */
    var $password_func = 'md5';
    /**
     * ͤ򥻥åȤ륻åѿ̾
     *
     * @access private
     * @var string
     */
    var $challenge_response_session_name = 'syl_auth_challenge';

    /**
     * SyL_Auth饹Υ󥹥󥹼
     *
     * singletonǥѤƤΤǡ
     * 1ĤΥ󥹥󥹤λȤ롣
     *
     * ˡ
     *   $SyL_Auth =& SyL_Auth::getInstance();
     *
     * @access public
     */
    function &getInstance()
    {
        static $singleton;
        if (!is_object($singleton)) {
            list($type) = explode(':', SYL_AUTH_TYPE, 2);
            $singleton = SyL_Auth::createAuth($type);
        }
        return $singleton;
    }

    /**
     * ǧڥ֥Ȥ
     * 
     * @static
     * @access protected
     * @param string ǧڥ
     * @return object ǧڥ֥
     */
    function createAuth($type)
    {
        $classname = 'SyL_Auth' . ucfirst($type);
        include_once SYL_INCLUDE_DIR . "/framework/Auth/{$classname}.php";
        $obj = new $classname();
        $request =& SyL_Request::getInstance();
        $obj->session =& $request->getSessionObject();
        return $obj;
    }

    /**
     * 桼IDѥ᡼̾򥻥å
     * 
     * @access public
     * @param string 桼IDѥ᡼̾
     */
    function setUserParamaterName($username)
    {
        $this->username = $username;
    }

    /**
     * ѥɥѥ᡼̾򥻥å
     * 
     * @access public
     * @param string ѥɥѥ᡼̾
     */
    function setPasswordParamaterName($password)
    {
        $this->password = $password;
    }

    /**
     * å̾򥻥å
     * 
     * @access public
     * @param string å̾
     */
    function setSessionName($session_name)
    {
        $this->session_name = $session_name;
    }

    /**
     * ѥɰŹ沽ؿ̾򥻥å
     * 
     * @access public
     * @param string ѥɰŹ沽ؿ̾
     */
    function setPasswordFunc($password_func)
    {
        $this->password_func = $password_func;
    }

    /**
     * ǧڥꥢȽ
     * 
     * @access public
     * @return bool true: ǧڥꥢfalse: ǧڥꥢ
     */
    function isAuthArea()
    {
        $request_uri = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '/';
        return (bool)preg_match('/^' . preg_quote(SYL_AUTH_URL, '/') . '/', $request_uri);
    }

    /**
     * 󥢥Ƚ
     * 
     * @access public
     * @return bool true: 󥢥󤢤ꡢfalse: 󥢥ʤ
     */
    function isLoginAction()
    {
        return false;
    }

    /**
     * ǧڼ¹
     * 
     * @access public
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function doLogin()
    {
        return false;
    }

    /**
     * ǧڥѥȽ
     * 
     * @access protected
     * @param string 饤桼̾
     * @param string 饤ѥ
     * @param string С¦ѥ
     * @param bool С¦ϥåե饰
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function isLoginPassword($client_username, $client_password, $server_password, $server_hash)
    {
        if (!$this->isLoginAction()) {
            SyL_Loggers::warn("[Auth] Login Failed. No Login Action: class = " . get_class($this) . " user = {$client_username} hash = " . SYL_AUTH_PASSWORD_HASH);
            return false;
        }
        if (($client_username === null) || ($client_username === '')) {
            SyL_Loggers::warn("[Auth] Login Failed. Empty UserName: class = " . get_class($this) . " user = {$client_username} hash = " . SYL_AUTH_PASSWORD_HASH);
            return false;
        }

        if (SYL_AUTH_PASSWORD_HASH) {
            // 饤¦ : md5(  md5(ѥ))
            // С¦     : md5(  ѥ) or md5(  md5(ѥ))
            $challenge = $this->getChallengeCode();
            if ($challenge === null) {
                trigger_error("[SyL error] Unable to get of Challenge Code", E_USER_ERROR);
            }
            if (!$server_hash) {
                $server_password = call_user_func(SYL_AUTH_PASSWORD_HASH, $server_password);
            }
            $server_password = call_user_func(SYL_AUTH_PASSWORD_HASH, $challenge . $server_password);
        }

        if ($server_password == $client_password) {
            $this->session->setParameter($this->session_name, $client_username);
            SyL_Loggers::info("[Auth] Login Success: class = " . get_class($this) . " user = {$client_username} hash = " . SYL_AUTH_PASSWORD_HASH);
            return true;
        } else {
            SyL_Loggers::warn("[Auth] Login Failed. Invalid Password: class = " . get_class($this) . " user = {$client_username} hash = " . SYL_AUTH_PASSWORD_HASH);
            return false;
        }
    }

    /**
     * ǧڥå
     * 
     * @access public
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function isLogin()
    {
        return $this->session->isParameter($this->session_name);
    }

    /**
     * ȽԤ
     * 
     * @access public
     * @return boolean OK: true, NG: false
     */
    function doLogout()
    {
        $this->session->deleteParameters();
    }

    /**
     * 󥸥ɤå˥åȤơ
     * ASCIIɤΡ'(39)~פޤǤͤǼ
     * 
     * @access public
     * @param string 󥸥ɤη
     * @return string 󥸥
     */
    function createChallengeCode($len=8)
    {
        $challenge = '';
        for ($i=0; $i<$len; $i++) {
            $challenge .= chr(mt_rand(48, 126));
        }
        $challenge = str_replace('\\', '_', $challenge); // \ ֤
        $this->session->setParameter($this->challenge_response_session_name, $challenge);
        return $challenge;
    }

    /**
     * 󥸥ɤ
     * 
     * @access public
     * @return string 󥸥
     */
    function getChallengeCode()
    {
        $challenge = $this->session->getParameter($this->challenge_response_session_name);
        return $challenge;
    }

    /**
     * TOPURL
     * 
     * @access public
     */
    function getRedirectUrl()
    {
        return SYL_AUTH_URL;
    }

    /**
     * TOP̤إ쥯
     * 
     * @access public
     */
    function redirect()
    {
        SyL_Response::redirect(SYL_AUTH_URL);
    }

    /**
     * å󥨥顼̤إ쥯
     * 
     * @access public
     */
    function redirectSessionError()
    {
        SyL_Response::redirect(SYL_AUTH_SESSION_ERROR_URL);
    }

}

?>
