/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 */
function SyL_Calender(id, width)
{
  this.id    = id;
  this.width = (typeof(width) == "number")  ? String(width) + 'px' : width;
  this.year  = [];
  this.weeks = ["Sun","Mon","Tue","Wed","Thu","Fri","Sat"];

  this.currentDate     = '';
  this.callbackMonth   = null;
  this.callbackDay     = null;
  this.nationalHoliday = false;

  this.links = null;

  this.fontSize    = '12px';
  this.borderColor = '#C0C0C0';
  this.padding     = '3px';

  this.backgroundColorSunH = '#FFCCCC';
  this.backgroundColorSatH = '#C4E1FF';
  this.backgroundColorWekH = '#E0E0E0';
  this.fontColorSunH = '#CC3333';
  this.fontColorSatH = '#3333CC';
  this.fontColorWekH = '#444444';

  this.backgroundColorSun = '#FFDDDD';
  this.backgroundColorSat = '#E0EFFF';
  this.backgroundColorWek = '#F1F1F1';
  this.fontColorSun = '#CC3333';
  this.fontColorSat = '#3333CC';
  this.fontColorWek = '#666666';

  // IEȽ
  this.ie = (navigator.userAgent.indexOf("MSIE") > -1);
}

SyL_Calender.prototype = {
  /**
   * 򥻥å
   *
   * @param array 
   */
  setLinks: function(links)
  {
    this.links = null;
    this.links = links;
  },
  /**
   * ʽ
   *
   * @param string YYYYMM
   */
  createInit: function(ym)
  {
    var self = this;
    if (typeof(self.callbackMonth) == "function") {
      self.callbackMonth(ym);
    } else {
      self.create(ym, null);
    }
  },

  /**
   * 
   *
   * @param string YYYYMM
   * @param array 󥯥ѥ᡼
   */
  create: function(ym)
  {
    if (!ym.match(/^(\d{4})([01][0-9])$/g)) {
      alert("Invalid Date Parameter (" + ym + ")");
      return;
    }

    var y = parseInt(RegExp.$1, 10);
    var m = parseInt(RegExp.$2, 10);

    if ((m < 1) || (m > 12)) {
      alert("Invalid Date Parameter (" + ym + ")");
      return;
    }

    var prev = '';
    var next = '';
    switch (m) {
    case 1:
      prev = (y-1) + "12";
      next = y + "02";
      break;
    case 12:
      prev = y + "11";
      next = (y+1) + "01";
      break;
    default:
      prev = y + ((m-1<10) ? "0"+(m-1) : String(m-1));
      next = y + ((m+1<10) ? "0"+(m+1) : String(m+1));
      break;
    }

    var date = new Date(y, m-1, 1);
    // 1ܤ
    var weekdate = date.getDay();
    // κǽ
    var lastday = (new Date(y, m, 0)).getDate();

    var self = this;

    var div = document.getElementById(self.id);
    div.innerHTML = '';

    var table = document.createElement("table");
    table.width = self.width;
    with (table.style) {
      borderStyle = "solid";
      borderWidth = "1px";
      borderColor = self.borderColor;
      borderCollapse = "collapse";
    }

    var form  = document.createElement("form");
    var tbody = document.createElement("tbody");
    if (self.ie) {
      div.appendChild(table);
      table.appendChild(form);
      form.appendChild(tbody);
    } else {
      div.appendChild(form);
      form.appendChild(table);
      table.appendChild(tbody);
    }

    var tr = document.createElement("tr");
    var td = document.createElement("td");
    td.colSpan = "5";
    with (td.style) {
      fontSize  = self.fontSize;
      padding   = self.padding;
      textAlign = "left";
      backgroundColor = self.backgroundColorWek;
    }
    if (self.year.length > 0) {
      td.appendChild(self.createSelectYear(self.year, y));
      td.appendChild(document.createTextNode("/"));
      td.appendChild(self.createSelectMonth(m));
      td.appendChild(document.createTextNode(" "));
      td.appendChild(self.createSelectButton());
    } else {
      td.innerHTML = "&nbsp;" + y + "&nbsp;/&nbsp;" + m;
    }
    tr.appendChild(td);

    var td = document.createElement("td");
    td.colSpan = "2";
    with (td.style) {
      textAlign = "right";
      fontSize  = self.fontSize;
      padding   = self.padding;
      backgroundColor = self.backgroundColorWek;
    }

    var aprev = document.createElement("a");
    aprev.href    = "javascript: void(0);";
    aprev.onclick = function() {
      if (typeof(self.callbackMonth) == "function") {
        self.callbackMonth(prev);
      } else {
        self.create(prev);
      }
    };
    aprev.innerHTML = "";

    var anext = document.createElement("a");
    anext.href = "javascript: void(0);";
    anext.onclick = function() {
      if (typeof(self.callbackMonth) == "function") {
        self.callbackMonth(next);
      } else {
        self.create(next);
      }
    };
    anext.innerHTML = "";

    td.appendChild(aprev);
    td.appendChild(document.createTextNode(" | "));
    td.appendChild(anext);
    //td.innerHTML = td.innerHTML + "&nbsp;";
    tr.appendChild(td);
    tbody.appendChild(tr);

    // ̱ν
    var nationalHoliday = [];
    if (self.nationalHoliday) {
        nationalHoliday = self.getNationalHoliday(y, m);
    }

    var tr = document.createElement("tr");
    for(var i=0; i<7; i++) {
      var td = self.createTdDay(ym, null, i, true, nationalHoliday);
      td.innerHTML = self.weeks[i];
      tr.appendChild(td);
    }
    tbody.appendChild(tr);

    var day = 1;
    var first = true;
    while (true) {
      var tr = document.createElement("tr");
      var n = 0;
      if (first) {
        // blank day
        for (var i=0; i<weekdate; i++) {
          var td = self.createTdDay(ym, null, i, false, nationalHoliday);
          td.innerHTML = "&nbsp;";
          tr.appendChild(td);
        }
        n = weekdate;
        first = false;
      }

      for (var i=n; i<7; i++) {
        if (day > lastday) {
          for(var k=i; k<7; k++) {
            var td = self.createTdDay(ym, null, k, false, nationalHoliday);
            td.innerHTML = "&nbsp;";
            tr.appendChild(td);
          }
          break;
        }

        var td = self.createTdDay(ym, day, i, false, nationalHoliday);
        var a  = document.createElement("a");
        switch (i) {
        case 0:  a.style.color = self.fontColorSun; break;
        case 6:  a.style.color = self.fontColorSat; break;
        default: a.style.color = self.fontColorWek; break;
        }

        if (self.links) {
          a.style.textDecoration = "underline";
          if (self.links[day]) {
            if (typeof(self.callbackDay) == "function") {
              a.href = "javascript:void(0);";
              a.onclick = function ()
              {
                var d = parseInt(this.innerHTML, 10);
                self.callbackDay(y, m, d, self.links[d]);
              };
            } else {
              a.href = self.links[day];
            }
          } else {
            a.style.textDecoration = "none";
          }
        } else {
          if (typeof(self.callbackDay) == "function") {
            a.style.textDecoration = "underline";
            a.href = "javascript:void(0);";
            a.onclick = function () { self.callbackDay(y, m, parseInt(this.innerHTML, 10)); };
          } else {
            a.style.textDecoration = "none";
          }
        }
        a.appendChild(document.createTextNode(day));
        td.appendChild(a);
        tr.appendChild(td);
        day++;
      }
      tbody.appendChild(tr);

      if (day > lastday) {
        break;
      }
    }
  },

  createTdDay: function(ym, day, week, header, nationalHoliday)
  {
    var self = this;
    var cday = 0;
    if (ym && day && self.currentDate) {
      if (self.currentDate.substr(0, 6) == ym) {
        cday = parseInt(self.currentDate.substr(6, 2), 10);
      }
    }

    // ̱ν Ū˵ˡˤѴ
    if (nationalHoliday[day]) {
      week = 0;
    }
 
    var td = document.createElement("td");
    td.width = "14.2%";
    with (td.style) {
      fontSize    = self.fontSize;
      textAlign   = "center";
      borderStyle = "solid";
      borderWidth = "1px";
      borderColor = self.borderColor;
      padding     = self.padding;
      if (header) {
        borderBottomWidth = "3px";
        borderBottomStyle = "double";
      }
      if (day == cday) {
          fontWeight = "bold";
      }

      switch (week) {
      case 0:
        if (header) {
          backgroundColor = self.backgroundColorSunH;
          color = self.fontColorSunH;
        } else {
          backgroundColor = self.backgroundColorSun;
          color = self.fontColorSun;
        }
        break;
      case 6:
        if (header) {
          backgroundColor = self.backgroundColorSatH;
          color = self.fontColorSatH;
        } else {
          backgroundColor = self.backgroundColorSat;
          color = self.fontColorSat;
        }
        break;
      default:
        if (header) {
          backgroundColor = self.backgroundColorWekH;
          color = self.fontColorWekH;
        } else {
          backgroundColor = self.backgroundColorWek;
          color = self.fontColorWek;
        }
        break;
      }
    }

    return td;
  },

  /**
   * ǯץ
   *
   * @param array ɽǯ
   * @param int ǯ
   * @return object ץ
   */
  createSelectYear: function(y, year)
  {
    var select = document.createElement("select");
    for (var i in y) {
      var option = document.createElement("option");
      if (y[i] == year) {
        option.selected = true;
      }
      option.value = y[i];
      option.appendChild(document.createTextNode(y[i]));
      select.appendChild(option);
    }
    return select;
  },

  /**
   * ץ
   *
   * @param int 
   * @return object ץ
   */
  createSelectMonth: function(month)
  {
    var select = document.createElement("select");
    for (var i=1; i<=12; i++) {
      var option = document.createElement("option");
      if (i == month) {
        option.selected = true;
      }
      i = (i < 10) ? "0"+i : String(i);
      option.value = i;
      option.appendChild(document.createTextNode(i));
      select.appendChild(option);
    }
    return select;
  },

  /**
   * OKܥ
   *
   * @return object OKܥ
   */
  createSelectButton: function()
  {
    var self = this;
    var input = document.createElement("input");
    input.type = "button";
    input.value = "OK";
    input.onclick = function() {
      var y = this.form.elements[0].options[this.form.elements[0].selectedIndex].value;
      var m = this.form.elements[1].options[this.form.elements[1].selectedIndex].value;
      self.create(y + m);
    }
    return input;
  },

  /**
   * ̱ν
   *
   * @param int ǯ
   * @param int 
   * @return array ̱ν
   */
  getNationalHoliday: function(year, month)
  {
    var nationalHoliday = [];

    var self = this;
    switch (month) {
    // 1
    case 1:
      // 
      if (self.isSunday(year, month, 1)) {
        nationalHoliday[2] = true;
      } else {
        nationalHoliday[1] = true;
      }
      // ͤ
      var day = self.getFirstMonday(year, month) + 7;
      nationalHoliday[day] = true;
      break;
    // 2
    case 2:
      // ǰ
      if (self.isSunday(year, month, 11)) {
        nationalHoliday[12] = true;
      } else {
        nationalHoliday[11] = true;
      }
      break;
    // 3
    case 3:
      // ʬ
      if ((year > 1979) && (year < 2100)) {
        var day = parseInt(20.8431 + 0.242194 * (year - 1980) - parseInt((year - 1980) / 4));
        if (self.isSunday(year, month, day)) {
          nationalHoliday[day+1] = true;
        } else {
          nationalHoliday[day] = true;
        }
      }
      break;
    // 4
    case 4:
      // ߤɤ
      if (self.isSunday(year, month, 29)) {
        nationalHoliday[30] = true;
      } else {
        nationalHoliday[29] = true;
      }
      break;
    // 5
    case 5:
      // ˡǰ
      // ̱ε
      // ɤ
      if (self.isSunday(year, month, 3)) {
        nationalHoliday[4] = true;
        nationalHoliday[5] = true;
        nationalHoliday[6] = true;
      } else if (self.isSunday(year, month, 4)) {
        nationalHoliday[3] = true;
        nationalHoliday[5] = true;
        nationalHoliday[6] = true;
      } else if (self.isSunday(year, month, 5)) {
        nationalHoliday[3] = true;
        nationalHoliday[4] = true;
        nationalHoliday[6] = true;
      } else {
        nationalHoliday[3] = true;
        nationalHoliday[4] = true;
        nationalHoliday[5] = true;
      }
      break;
    // 6
    case 6: break;
    // 7
    case 7:
      // 
      var day = self.getFirstMonday(year, month) + 14;
      if (self.isSunday(year, month, day)) {
        nationalHoliday[day+1] = true;
      } else {
        nationalHoliday[day] = true;
      }
      break;
    // 8
    case 8: break;
    // 9
    case 9:
      // ʬ
      if ((year > 1979) && (year < 2100)) {
        var day = parseInt(23.2488 + 0.242194 * (year - 1980) - parseInt((year - 1980) / 4));
        if (self.isSunday(year, month, day)) {
          nationalHoliday[day+1] = true;
        } else {
          nationalHoliday[day] = true;
        }
      }
      // Ϸ
      var day = self.getFirstMonday(year, month) + 14;
      if (self.isSunday(year, month, day)) {
        nationalHoliday[day+1] = true;
      } else {
        nationalHoliday[day] = true;
      }
      break;
    // 10
    case 10:
      // ΰ
      var day = self.getFirstMonday(year, month) + 7;
      if (self.isSunday(year, month, day)) {
        nationalHoliday[day+1] = true;
      } else {
        nationalHoliday[day] = true;
      }
      break;
    // 11
    case 11:
      // ʸ
      if (self.isSunday(year, month, 3)) {
        nationalHoliday[4] = true;
      } else {
        nationalHoliday[3] = true;
      }
      // ϫդ
      if (self.isSunday(year, month, 23)) {
        nationalHoliday[24] = true;
      } else {
        nationalHoliday[23] = true;
      }
      break;
    // 12
    case 12:
      // ŷ
      if (self.isSunday(year, month, 23)) {
        nationalHoliday[24] = true;
      } else {
        nationalHoliday[23] = true;
      }
      break;
    }

    return nationalHoliday;
  },

  /**
   * κǽη
   *
   * @param int ǯ
   * @param int 
   * @return int κǽη
   */
  getFirstMonday: function(year, month)
  {
    for(var day=1; day<=7; day++) {
        if ((new Date(year, month-1, day)).getDay() == 1) {
            return day;
        }
    }
  },

  /**
   * Ƚ
   *
   * @param int ǯ
   * @param int 
   * @param int 
   * @return bool true: false: ʳ
   */
  isSunday: function(year, month, day)
  {
    return ((new Date(year, month-1, day)).getDay() == 0);
  }
}

