<?php
/**
 * ƥץ졼ȥեݡͥȥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: C_CreateTemplate.php,v 1.3 2006/12/23 11:14:31 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class C_CreateTemplate
{
    /**
     * ƥץ졼ȥե
     *
     * @access public
     * @param string ץȥǥ쥯ȥ
     * @param string ץꥱ̾
     * @param string ƥץ졼ȥե
     */
    function trigger($project_dir, $app_name, $template_file)
    {
        $template_dir = "{$project_dir}app/{$app_name}/templates";
        if (!is_dir($template_dir)) {
            if (!mkdir($template_dir, 0755)) {
                trigger_error("[SyL error] template directory can't create ({$template_dir})", E_USER_ERROR);
                exit;
            }
        }

        if (!is_array($template_file)) {
            $template_file = array($template_file);
        }

        for ($i=0; $i<count($template_file); $i++) {
            if (!preg_match('/^(\\\\|\/)/', $template_file[$i])) {
                $template_file[$i] = '/' . $template_file[$i];
            }
            $file = substr($template_file[$i], 1);
            if (substr($file, -5) == '.html') {
                $file = substr($file, 0, -5);
            } else {
                $template_file[$i] .= '.html';
            }

            $file = $template_dir . $template_file[$i];
            $tmp = dirname($file) . '/';
            $create_dir = array();
            while (preg_match('/^' . preg_quote($template_dir, '/') . '/', $tmp)) {
                array_unshift($create_dir, $tmp);
                $tmp = dirname($tmp);
            }

            foreach ($create_dir as $dir) {
                if (!is_dir($dir)) {
                    echo "  creating directory {$dir}\n"; ob_flush();
                    mkdir($dir, 0755);
                }
            }

            echo "  copying file {$file}\n"; ob_flush();
            if (file_exists("{$project_dir}var/skel-templates/template.html")) {
                copy("{$project_dir}var/skel-templates/template.html", $file);
            } else {
                copy(SYL_WEBAPP_DIR . '/var/skel-templates/template.html', $file);
            }
        }
    }
}

?>
