<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Mail.php,v 1.8 2007/01/06 14:23:05 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ᡼ƤΥ󥳡ǥ
 */
if (!defined('SYL_ENCODE_MAIL')) {
    define('SYL_ENCODE_MAIL', 'ISO-2022-JP');
}
/**
 * 󥳡ǥ
 */
if (!defined('SYL_ENCODE_INTERNAL')) {
    define('SYL_ENCODE_INTERNAL', 'EUC-JP');
}

/**
 * ᡼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Mail.php,v 1.8 2007/01/06 14:23:05 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Mail
{
    /**
     * ᡼إå
     * 
     * @access protected
     * @var array
     */
    var $headers = array();
    /**
     * ᡼إåʤ¾
     * 
     * @access protected
     * @var array
     */
    var $headers_etc = array();
    /**
     * ᡼ʸ
     * 
     * @access protected
     * @var string
     */
    var $body = '';
  
    /**
     * źեե̾
     * 
     * @access protected
     * @var array
     */
    var $f_name = array();
    /**
     * źեե
     * 
     * @access protected
     * @var array
     */
    var $f_contents = array();
    /**
     * Х
     * 
     * @access protected
     * @var string
     */
    var $f_boundary = '';
  
    /**
     * X-Mailerإå
     * 
     * @access protected
     * @var string
     */
    var $x_mailer = 'SyL Mail';

/*
  var $htmail;
*/

    /**
     * ᡼ƤΥ󥳡
     * 
     * @access protected
     * @var string
     */
    var $mail_encode = SYL_ENCODE_MAIL;
    /**
     * ѥ᡼Υ󥳡
     * 
     * @access protected
     * @var string
     */
    var $internal_encode = SYL_ENCODE_INTERNAL;
    /**
     * 顼å
     * 
     * @access protected
     * @var string
     */
    var $error_message = '';

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     */
    function SyL_Mail()
    {
        // ʲǥեȥإå
        $this->headers_etc['Mime-version'] = '1.0';
        $this->headers_etc['Content-type'] = 'text/plain; charset="iso-2022-jp"';
        $this->headers_etc['Content-transfer-encoding'] = '7bit';
        if ($this->x_mailer != '') {
            $this->headers_etc['X-Mailer'] = $this->x_mailer;
        }

        $this->init();
    }

    /**
     * SyL_Mail饹Υ󥹥󥹼
     *
     * Mail֥Ⱥ
     *
     * ˡ
     *   $mail =& SyL_Mail::getInstance();
     *
     * @access public
     */
    function &getObject($type='Default')
    {
        $class_name = 'SyL_Mail' . ucfirst($type);
        include_once dirname(__FILE__) . '/Mail/' . $class_name . '.php';
        $obj = new $class_name();
        return $obj;
    }

//  function setHtml( $flag=true )
//  {
//    if ($flag) {
//      $this->headers['Content-Type'] =  'multipart/alternative; boundary=--wbmd-multipart--';
//      $this->htmail = true;
//    } else {
//      $this->headers['Content-type'] = 'text/plain; charset="ISO-2022-JP"';
//      $this->htmail = false;
//    }
//  }

    /**
     * ɥ쥹򥻥å
     *
     * ڡڤǡ̾⥻åȤ뤳Ȥǽ
     * ˥åʸ: hoge@example.com ۥ
     *     ʸ:   ۥ <hoge@example.com>
     * 
     * @access public
     * @param string ɥ쥹
     */
    function setFrom($from, $name='')
    {
        $this->headers['From'] = $this->convertEncodingAddress($from, $name, true);
    }

    /**
     * 襢ɥ쥹򥻥å
     * ڡڤǡ̾⥻åȤ뤳Ȥǽ
     * ˥åʸ: hoge@hogehoge.com ۥ
     *     ʸ:   ۥ <hoge@hogehoge.com>
     * 
     * @access public
     * @param string 襢ɥ쥹
     */
    function addTo($to, $name='')
    {
        if (is_array($to)) {
            foreach($to as $tmp) {
                $this->addTo($tmp, $name);
            }
        } else {
            $this->headers['To'][] = $this->convertEncodingAddress($to, $name);
        }
    }

    /**
     * 襢ɥ쥹(CC)򥻥å
     * ڡڤǡ̾⥻åȤ뤳Ȥǽ
     * ˥åʸ: hoge@hogehoge.com ۥ
     *     ʸ:   ۥ <hoge@hogehoge.com>
     * 
     * @access public
     * @param string 襢ɥ쥹(CC)
     */
    function addCc($cc, $name='')
    {
        if (is_array($cc)) {
            foreach($cc as $tmp) {
                $this->addCc($tmp, $name);
            }
        } else {
            $this->headers['Cc'][] = $this->convertEncodingAddress($cc, $name);
        }
    }

    /**
     * 襢ɥ쥹(BCC)򥻥å
     * ڡڤǡ̾⥻åȤ뤳Ȥǽ
     * ˥åʸ: hoge@hogehoge.com ۥ
     *     ʸ:   ۥ <hoge@hogehoge.com>
     * 
     * @access public
     * @param string 襢ɥ쥹(BCC)
     */
    function addBcc($bcc, $name='')
    {
        if (is_array($bcc)) {
            foreach($bcc as $tmp) {
                $this->addBcc($tmp, $name);
            }
        } else {
            $this->headers['Bcc'][] = $this->convertEncodingAddress($bcc, $name);
        }
    }

    /**
     * ̾򥻥å
     * 
     * @access public
     * @param string ̾
     */
    function setSubject($subject)
    {
        $this->headers['Subject'] = $this->convertEncoding($subject, true);
    }

    /**
     * ʸ򥻥å
     * 
     * @access public
     * @param string ʸ
     */
    function setBody($body)
    {
        $this->body = $this->convertEncoding($body);
    }

    /**
     * ѥ᡼Υ󥳡ɤ򥻥å
     *
     * @access public
     * @param string ѥ᡼Υ󥳡
     */
    function setParameterEncode($encode)
    {
        $this->internal_encode = $encode;
    }

    /**
     * ᡼ƤΥ󥳡ɤ򥻥å
     *
     * @access public
     * @param string ᡼ƤΥ󥳡
     */
    function setMailEncode($encode)
    {
        $this->mail_encode = $encode;
    }

    /**
     * ѥ᡼᡼ʸ˥󥳡ɤ
     *
     * @access private
     * @param string 󥳡оʸ
     * @param bool MIME󥳡ɥե饰
     * @return 󥳡ɸʸ
     */
    function convertEncoding($parameter, $mime_encode=false)
    {
        $parameter = mb_convert_encoding($parameter, $this->mail_encode, $this->internal_encode);
        if ($mime_encode) {
            $parameter = mb_encode_mimeheader($parameter, $this->mail_encode);
        }
        return $parameter;
    }

    /**
     * ᡼륢ɥ쥹᡼ʸ˥󥳡ǥ
     * 
     * @access public
     * @param string ᡼륢ɥ쥹
     * @param string ᡼륢ɥ쥹̾
     * @param bool Fromե饰
     * @return string 󥳡ǥ󥰤Υ᡼륢ɥ쥹
     */
    function convertEncodingAddress($address, $name='', $from=false)
    {
        $address = explode(' ', trim($address), 2);

        if (($name == '') && isset($address[1])) {
            $name = $address[1];
        }

        if ($from) {
            $this->headers['MAIL_FROM'] = $address[0];
            $this->headers_etc['Reply-To'] = $address[0];
        } else {
            $this->headers['RCPT_TO'][] = $address[0];
        }

        if (isset($address[1]) && (trim($address[1]) != '')) {
            return '"' . $this->convertEncoding($name, true) . '" <' . $address[0] . '>';
        } else {
            return '"' . $address[0] . '" <' . $address[0] . '>';
        }
    }

    /**
     * ¾Υ᡼إå򥻥å
     * 
     * @access public
     * @param string إåΥ
     * @param string إå
     */
    function setHeader($key, $value)
    {
        $this->headers_etc[$key] = $value;
    }

    /**
     * ¾Υ᡼إå򥻥åȡʣб
     * 
     * @access public
     * @param array إåΥͤΥڥ
     */
    function setHeaders($headers)
    {
        $this->headers_etc = array_merge($this->headers_etc, $headers);
/*
    foreach ($headers as $key => $value) {
      $this->setHeader($key, $value);
    }
*/
    }

    /**
     * źեե򥻥å
     * 
     * @access public
     * @param string եѥʥե̾ޤǴޤ
     */
    function setFile($path)
    {
        // źեե
        $f_contents = file_get_contents($path);
        // ե̾
        $f_name = basename($path);
        // źեեѥإåå
        $this->headers_etc['Content-type'] = 'multipart/mixed; boundary=' . $this->f_boundary . ';';
        $this->headers_etc['Content-transfer-encoding'] = 'Base64';
        // źեե󥻥å
        $this->f_name[]     = $this->convertEncoding($f_name, true);
        $this->f_contents[] = chunk_split(base64_encode($f_contents));
    }

    /**
     * ᡼
     *
     * @access public
     * @param array ᡼°
     * @param bool ե饰
     */
    function init($attributes=array())
    {
        $attributes = array_change_key_case($attributes, CASE_LOWER);

        // ǡ
        $this->headers['MAIL_FROM'] = '';
        $this->headers['RCPT_TO']   = array();

        // 긵
        $this->headers['From'] = '';
        if (isset($attributes['from'])) {
            $this->setFrom($attributes['from']);
        }
        // 
        $this->headers['To'] = array();
        if (isset($attributes['to'])) {
            $this->setTo($attributes['to']);
        }
        // Cc
        $this->headers['Cc'] = array();
        if (isset($attributes['cc'])) {
            $this->setCc($attributes['cc']);
        }
        // Bcc
        $this->headers['Bcc'] = array();
        if (isset($attributes['bcc'])) {
            $this->setBcc($attributes['bcc']);
        }
        // ̾
        $this->headers['Subject'] = '';
        if (isset($attributes['subject'])) {
            $this->setSubject($attributes['subject']);
        }
        // ̾
        $this->body = '';
        if (isset($attributes['body'])) {
            $this->setBody($attributes['body']);
        }

        $this->f_name     = array();
        $this->f_contents = array();
        $this->f_boundary = "-=-=-=-=-=-=-=-=-Boundary_" . uniqid("b");
 
//    $this->htmail           = false;
  }

    /**
     * ᡼إåޤʸ
     *
     * @access public
     * @param string ʸ
     * @return string ᡼إåޤʸ
     */
    function getHeaderMessage($body)
    {
        // ᡼إå
        $data  = '';
        $data .= 'Subject: ' . $this->headers['Subject'] . "\r\n";
        $data .= 'From: '    . $this->headers['From']    . "\r\n";
        $data .= 'To: '      . implode(', ', $this->headers['To']) . "\r\n";
        if (count($this->headers['Cc']) > 0) {
            $data .= 'Cc: ' . implode(', ', $this->headers['Cc'])  . "\r\n";
        }
        if (count($this->headers['Bcc'] ) > 0) {
            $data .= 'Bcc: ' . implode(', ', $headers['Bcc']) . "\r\n";
        }
        foreach ($this->headers_etc as $key => $value) {
            $data .= $key . ': ' . $value . "\r\n";
        }
        $data .= "\r\n";

        // ᡼ʸ
        if (count($this->f_name) > 0) {
            // -------------------------------
            // źեեդƥȥ᡼
            // -------------------------------
            $data .= '--' . $this->f_boundary . "\r\n";
            $data .= 'Content-Type: text/plain; charset="iso-2022-jp"' . "\r\n";
            $data .= "\r\n";
            $data .= $body . "\r\n";
            for ($i=0; $i<count($this->f_name); $i++) {
                $data .= '--' . $this->f_boundary . "\r\n";
                $data .= 'Content-Type: application/octet-stream; name="' . $this->f_name[$i] . '"' . "\r\n";
                $data .= 'Content-Disposition: attachment; filename="'    . $this->f_name[$i] . '"' . "\r\n";
                $data .= 'Content-Transfer-Encoding: base64' . "\r\n";
                $data .= "\r\n";
                $data .= $this->f_contents[$i] . "\r\n";
                $data .= "\r\n";
            }
            $data .= '--' . $this->f_boundary . "--\r\n";
        } else {
            // ̾Υƥȥ᡼
            $data .= $body . "\r\n";
        }

        return $data;
    }


    /**
     * ᡼¹
     *
     * @access public
     * @return OK: true, NG: false
     */
    function send()
    {
    }

    /**
     * ᡼
     *
     * @access public
     * @return OK: true, NG: false
     */
    function quit()
    {
    }

    /**
     * 顼åȽ
     *
     * @access public
     * @return string 顼å
     */
    function isError()
    {
        return ($this->error_message != '');
    }

    /**
     * 顼å
     *
     * @access public
     * @return string 顼å
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }
}

?>
