<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSmtp.php,v 1.8 2007/01/06 14:23:05 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * å³饹
 */
require_once dirname(dirname(__FILE__)) . '/SyL_Socket.php';

/**
 * ᡼륵С
 */
if (!defined('SYL_MAIL_TYPE')) {
    define('SYL_MAIL_TYPE', 'Smtp::');
}

/**
 * SMTP᡼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSmtp.php,v 1.8 2007/01/06 14:23:05 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_MailSmtp extends SyL_Mail
{
    /**
     * ᡼륵СΥۥ̾
     *
     * @access private
     * @var string
     */
    var $host = '';
    /**
     * ᡼륵СΥݡ
     *
     * @access private
     * @var int
     */
    var $port = 25;
    /**
     * 
     *
     * @access private
     * @var string
     */
    var $command_log = '';
    /**
     * åȥ饹
     *
     * @access private
     * @var object
     */
    var $socket = null;

    /**
     * 󥹥ȥ饯
     *
     * @access private
     */
    function SyL_MailSmtp()
    {
        $tmp = explode(':', SYL_MAIL_TYPE, 3);
        if (strtolower($tmp[0]) != 'smtp') {
            $tmp[2] = $tmp[1];
            $tmp[1] = $tmp[0];
        }
        if ($tmp[1] != '') {
            $this->host = $tmp[1];
        }
        if (isset($tmp[2]) && is_numeric($tmp[2])) {
            $this->port = $tmp[2];
        }
        parent::SyL_Mail();
    }

    /**
     * ۥȤ򥻥å
     * 
     * @access public
     * @param string ۥ̾
     */
    function setHost($host)
    {
        $this->host = $host;
    }

    /**
     * ݡֹ򥻥å
     * 
     * @access public
     * @param int ݡֹ
     */
    function setPort($port)
    {
        $this->port = $port;
    }

    /**
     * ᡼
     *
     * @access public
     * @param array ᡼°
     * @param bool ե饰
     */
    function init($attributes=array())
    {
        $attributes = array_change_key_case($attributes, CASE_LOWER);
        parent::init($attributes);

        // ۥȥå
        if (isset($attributes['host'])) {
            $this->host = $attributes['host'];
        }
        // ݡȥå
        if (isset($attributes['port'])) {
            $this->port = $attributes['port'];
        }
    }

    /**
     * ᡼륵С³
     *
     * @access public
     * @param string ᡼륵С
     * @param int ݡֹ
     * @return OK: true, NG: false
     */
    function connect($server='', $port=25)
    {
        if ($server != '') {
            $this->setHost($server);
        }
        if ($port != '') {
            $this->setPort($port);
        }

        if (is_object($this->socket)) {
            $this->quit();
        }
        // åȥ֥Ⱥ
        $this->socket = new SyL_Socket($this->host, $this->port);
        $this->socket->setCommandCallBackFunc(array(&$this, 'receiveMessage'));

        if (!$this->socket->open()) {
            $this->error_message = $this->socket->getLastError();
            return false;
        } else {
            // ³å
            $this->socket->receive();
            // å
            $this->socket->send('HELO ' . $this->host);
            // å
            $this->socket->receive();
        }

        return true;
    }

    /**
     * ᡼¹
     *
     * @access public
     * @return OK: true, NG: false
     */
    function send()
    {
        // Fromɬ
        if ($this->headers['MAIL_FROM'] == '') {
            $this->error_message = "[SyL error] From Address not found";
            return false;
        }
        // Toɬ
        if (count($this->headers['To']) == 0) {
            $this->error_message = "[SyL error] To Address not found";
            return false;
        }

        // åȺȽ
        $once = false;
        if ($this->socket == null) {
            $once = true;
            $this->connect();
        }

        // ޥȯ ------------------------------------------------------------

        // åȥå
        $this->socket->send('MAIL FROM: ' . $this->headers['MAIL_FROM']);
        // åȥå
        $this->socket->receive();

        foreach ($this->headers['RCPT_TO'] as $to) {
            // 襻åȥå
            $this->socket->send('RCPT TO: ' . $to);
            // 襻åȥå
            $this->socket->receive();
        }

        if ($this->isError()) {
            if ($once) {
                $this->quit();
            }
            return false;
        }

        // ᡼إå ----------------------------------------------------------

        // ǡåȥå
        $this->socket->send('DATA');
        // ǡåȥå
        $this->socket->receive();

        // ᡼إåޤʸ
        // .פϥ
        $data = $this->getHeaderMessage(preg_replace('/(\r\n|\n|\r)\.(\r\n|\n|\r)/s', '$1..$2', $this->body));
        // Ǹˡ.פղ
        $data .= '.';

        if ($this->isError()) {
            if ($once) {
                $this->quit();
            }
            return false;
        }

        // -------------------------------------------------------------------------

        // ǡåȥå
        $this->socket->send($data);
        // ǡåȥå
        $this->socket->receive();

        if ($this->isError()) {
            if ($once) {
                $this->quit();
            }
            return false;
        }

        // ꥻåȥå
        $this->socket->send('RSET');
        // ꥻåȥå
        $this->socket->receive();

        if ($once) {
            $this->quit();
        }

        // 
        $this->init();

        return true;
    }

    /**
     * ᡼륵СȤ³Ĥ
     *
     * @access public
     */
    function quit()
    {
        if (is_object($this->socket)) {
            // λå
            $this->socket->send('QUIT');
            // λå
            $this->socket->receive();
            // åȤĤ
            $this->socket->close();
        }

        $this->socket = null;
    }

    /**
     * SMTPޥɼå
     *
     * @access private
     * @param string send or receive
     * @param string ޥɥå
     */
    function receiveMessage($type, $message)
    {
        $this->command_log .= "[{$type}] {$message}\n";
        if ($type == 'receive') {
            if (preg_match('/^[4|5][0-9]{2}/', $message)) {
                $this->error_message = "[SyL error] SMTP command error ($message)";
                return false;
            } else {
                return true;
            }
        } else {
            return true;
        }
    }

    /**
     * åȥޥɼ
     *
     * @access public
     * @return string åȥޥɼ
     */
    function getCommandLog()
    {
        return $this->command_log;
    }
}

?>
