<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementPassword.php,v 1.7 2006/12/23 11:13:09 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥɥեǥ饹
 *
 * ̾ : ̾ : ̾(name) : (value)
 *   1  :      -     :    1         :   1
 *
 * 󥹥󥹺ˡ
 * // 쥯饹饹ƥå᥽åɤǼ
 * $SyL_FormElementPassword = SyL_FormElement::createElement( 'password', 'passwd', 'ѥ' );
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementPassword.php,v 1.7 2006/12/23 11:13:09 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FormElementPassword extends SyL_FormElement
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string եHTML̾
     * @param string եɽ̾
     * @param string եǤ
     * @param array եǤradio, select, checkboxξΤߡ
     * @param string եǤɲ°
     */
    function SyL_FormElementPassword($name, $display_name, $options=array(), $value=null, $attributes=array())
    {
        $this->type = 'password';
        $this->name = $name;
        $this->display_name = $display_name;
        // ǥեͤμ
        $this->value     = ($value === null) ? $this->getParameter() : $value;
        $this->attributes = $attributes;
    }

    /**
     * եHTML
     * С饤
     *
     * @access public
     * @param bool true: html󥳡ɤԤfalse: html󥳡ɤԤʤ
     * @return string եǤHTML
     */
    function getHtmlTag( $html_encode=true )
    {
        $html_element  = '';
        $html_element .= '<input ';
        $html_element .=   'type="'  . $this->type      . '" ';
        $html_element .=   'name="'  . $this->name . '" ';
        $html_element .= $this->getAttribute();
        $html_element .= '>';

        return $html_element;
    }

    /**
     * եHTML
     * С饤
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlView()
    {
        $label = ($this->value != '') ? '**********' : '';
        return $label . $this->getHtmlHidden();
    }
}

?>
