<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementCheckbox.php,v 1.7 2006/12/23 11:13:09 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * åܥåեǥ饹
 *
 * ̾ : ̾ : ̾(name) : (value)
 *   1  :      n     :    n         :  n
 *
 * 󥹥󥹺ˡ
 * ѥ
 * $checkbox = array( '1' => 'åܥå1',
 *                    '2' => 'åܥå2',
 *                    '3' => 'åܥå3' );
 *
 * $SyL_Form->setElement( SyL_FormElement::createElement( 'checkbox', 'chk', 'å', $checkbox );
 *
 * // html result
 * <input type="checkbox" name="chk[]" value="1">åܥå1
 * <input type="checkbox" name="chk[]" value="2">åܥå2
 * <input type="checkbox" name="chk[]" value="3">åܥå3
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementCheckbox.php,v 1.7 2006/12/23 11:13:09 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FormElementCheckbox extends SyL_FormElement
{
    /**
     * Ǵ֤ζڤʸ
     *
     * @access private
     * @var string
     */
    var $element_separator = "&nbsp;\r\n";

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string եHTML̾
     * @param string եɽ̾ʥåܥåξΤ
     * @param string եǤ
     * @param array եǤradio, select, checkboxξΤߡ
     * @param string եǤɲ°
     */
    function SyL_FormElementCheckbox($name, $display_name, $options=array(), $value=null, $attributes=array())
    {
        $this->type         = 'checkbox';
        $this->name         = $name;
        $this->display_name = $display_name;
        $this->options      = $options;
        $this->attributes   = $attributes;
  
        // ǥեͤμ
        $value = ($value === null) ? $this->getParameter() : $value;
        if (!is_array($value)) {
            $value = array($value);
        }

        $this->value = array();
        foreach ($options as $k => $v) {
            if (in_array((string)$k, $value, true)) {
                $this->value[] = (string)$k;
            }
        }
    }

    /**
     * Ǵ֤ζڤʸ򥻥å
     *
     * @access public
     * @param string Ǵ֤ζڤʸ
     */
    function setSeparator( $separetor )
    {
        $this->element_separator = $separetor;
    }

    /**
     * եHTML
     * С饤
     *
     * @access public
     * @param bool true: html󥳡ɤԤfalse: html󥳡ɤԤʤ
     * @return string եǤHTML
     */
    function getHtmlTag()
    {
        $i = 0;
        $options = array();
        foreach ($this->options as $key => $value) {
            $id = $this->form_name . '_' . $this->name . '_' . $i;
            $checked = '';

            $html_element  = '';
            $html_element .= '<input ';
            $html_element .=   'type="' . $this->type . '" ';
            $html_element .=   'id="'   . $id                 . '" ';
            $html_element .=   'name="'  . $this->name . '[]" ';
            $html_element .=   'value="' . $this->encodeHtml($key)  . '" ';
            $html_element .= $this->getAttribute();
            if (in_array((string)$key, $this->value, true)) {
                $html_element .=   ' checked';
            }
            $html_element .= '>';
            $html_element .= '<label for="' . $id . '">';
            $html_element .= $this->encodeHtml($value);
            $html_element .= '</label>';
            $options[] = $html_element;
            $i++;
        }

        return implode($this->element_separator, $options);
    }

    /**
     * եHTML
     * С饤
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlView()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if (in_array((string)$key, $this->value, true)) {
                $options[] = $this->encodeHtml($value) . $this->getHtmlHidden($this->name . '[]', $key);
            }
        }
  
        return implode($this->element_separator, $options);
    }

    /**
     * JavaScriptϥå
     * С饤
     *
     * @access public
     * @return string JavaScriptϥå
     */
    function getJavaScript()
    {
        if (is_object($this->validators)) {
            $js  = '';
            $js .= 'var error_flag = false;' . "\r\n";
            $js .= 'var element_name = "' . $this->getName() . '[]";' . "\r\n";
            $js .= $this->validators->getJavaScript($this->getDisplayName(), $this->options);
            $js .= "\r\n";
            return $js;
        } else {
            return '';
        }
    }
}

?>
