<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Config.php,v 1.5 2006/12/11 11:59:42 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML饹
 */
require_once SYL_INCLUDE_DIR . '/lib/SyL_XMLParserOperation.php';

/** 
 * եɤ߹९饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Config.php,v 1.5 2006/12/11 11:59:42 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Config extends SyL_XMLParserOperation
{
    /**
     * ٥̾
     * 
     * @access private
     * @var string
     */
    var $event = '';
    /**
     * ե
     * 
     * @access private
     * @var array
     */
    var $config = array();
    /**
     * ǥեȼ¹Խ
     * 
     * @param int
     */
    var $default_priority = 5;
    /**
     * ȥ饪֥
     * 
     * @access private
     * @var object
     */
    var $controller = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string XMLե̾
     */
    function SyL_Config($file_name)
    {
        // ƥ饹Υ󥹥ȥ饯
        parent::SyL_XMLParserOperation($file_name);
    }

    /**
     * ե륪֥Ȥ
     *
     * @static
     * @access public
     * @param string ٥̾
     * @param string ե륪֥̾
     * @param string ե̾
     * @param object ȥ饪֥
     * @return object SyL_Container֥
     */
    function &getObject($config_name, $file_name, &$controller, $event='')
    {
        $class_name = 'SyL_Config' . ucfirst($config_name);
        include_once SYL_INCLUDE_DIR . "/framework/Config/{$class_name}.php";
        $obj =& new $class_name($file_name);
        $obj->setController($controller);
        $obj->setEvent($event);
        return $obj;
    }

    /**
     * ȥ򥻥å
     *
     * @access public
     * @param object ȥ饪֥
     */
    function setController(&$controller)
    {
        $this->controller =& $controller;
    }

    /**
     * ٥̾򥻥å
     *
     * @access public
     * @param string ٥̾
     */
    function setEvent($event)
    {
        $this->event = $event;
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
    }

    /**
     * XMLͤ
     * 
     * @return array XML
     */
    function getConfig()
    {
        return $this->config;
    }
}

?>
