<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestCookie.php,v 1.4 2006/12/11 11:59:42 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥ᡼ݻ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Request.php';

// ǥեȥåͭ
// 30 = time() + 60 * 60 * 24 * 30
// 0ξϥå󥯥å
define('SYL_COOKIE_EXPIRE', time() + 60 * 60 * 24 * 30);
// ǥեȥåѥ
define('SYL_COOKIE_PATH', '/');
// åɥᥤ
// ֥ɥᥤ
define('SYL_COOKIE_DOMAIN', '');
// åSSLΤ߻
define('SYL_COOKIE_SECURE', 0);

/**
 * åݻ饹
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestCookie.php,v 1.4 2006/12/11 11:59:42 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RequestCookie extends SyL_Request
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_RequestCookie()
    {
        // ѥ᡼
        $this->parameters =& $_COOKIE;
        // ޥåݥȤͭȽ
        if (get_magic_quotes_gpc()) {
            $this->applyParametersRecursive($this->parameters, 'stripslashes');
        }
    }

    /**
     * ѥ᡼򥻥å
     * 
     * @access public
     * @param string ѥ᡼̾
     * @param string ѥ᡼
     * @param int åͭ
     * @param string åͭȤѥ
     * @param string åͭʥɥᥤ
     * @param ing 奢HTTPS³ξˤΤߥåե饰
     */
    function setParameter($name, $value, $expire=SYL_COOKIE_EXPIRE, $path=SYL_COOKIE_PATH, $domain=SYL_COOKIE_DOMAIN, $secure=SYL_COOKIE_SECURE )
    {
        setcookie($name, $value, $expire, $path, $domain, $secure);
        parent::setParameter($name, $value);
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @param string ѥ᡼̾
     * @param string åͭȤѥ
     * @param string åͭʥɥᥤ
     * @param ing 奢HTTPS³ξˤΤߥåե饰
     */
    function deleteParameter($name, $path=SYL_COOKIE_PATH, $domain=SYL_COOKIE_DOMAIN, $secure=SYL_COOKIE_SECURE)
    {
        setcookie($name, '', time()-3600, $path, $domain, $secure);
        parent::deleteParameter($name);
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @param string åͭȤѥ
     * @param string åͭʥɥᥤ
     * @param ing 奢HTTPS³ξˤΤߥåե饰
     */
    function deleteParameterAll($path=SYL_COOKIE_PATH, $domain=SYL_COOKIE_DOMAIN, $secure=SYL_COOKIE_SECURE)
    {
        foreach ($this->parameters as $name => $value) {
            $this->deleteParameter($name, $path, $domain, $secure);
        }
        parent::deleteParameterAll();
    }
}

?>
