package mod.sf.jlynx;

import dwarf.hibermock.MockMetaDataCache;
import dwarf.sqlmock.MockConnection;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.*;

/**
 * Created on 2007/05/28, 
 *
 * @author HENMI
 */
public class JlynxHibSessionTest extends TestCase {
  
  public JlynxHibSessionTest(String testName) {
    super(testName);
  }

  protected void setUp() throws Exception {  }
  protected void tearDown() throws Exception {  }

  public static Test suite() {
    TestSuite suite = new TestSuite(JlynxHibSessionTest.class);
    return suite;
  }

  /**
   *  caɐڑȂŁAnq}bsOinserteXg
   */
  public void testInsert() throws Exception {
    System.out.println("insert");
    MockConnection con = new MockConnection();
    LinkedHashMap colMap = new LinkedHashMap();
    colMap.put("\P_ڂP", "2006-1-3");
    colMap.put("\P_ڂQ", "9928");
    colMap.put("\P_ڂR", "1234");
    
    JlynxHibSession instance = new JlynxHibSession(con);
    // eXgΏۃ\bhs
    int result = instance.insert(colMap);
    assertEquals(1, result);
    
    String cmd = con.getTestCalls();
    System.out.println("cmd" + cmd);
    assertEquals("INSERT INTO \P (ڂP,ڂQ,ڂR) VALUES ('2006-1-3','9928','1234')!", cmd);
  }
  /**
   *  caɐڑȂŁAnq}bsOinserteXg
   */
  public void testInsert2() throws Exception {
    System.out.println("insert2");
    MockConnection con = new MockConnection();
    LinkedHashMap colMap = new LinkedHashMap();
    colMap.put("\P.ڂP", "2006-1-3");
    colMap.put("\P.ڂQ", "9928");
    colMap.put("\P.ڂR", "1234");
    
    JlynxHibSession instance = new JlynxHibSession(con);
    instance.setSeparateCharacter(".");  // \ƍڂ̋؂蕶 .@ɕύX
    // eXgΏۃ\bhs
    int result = instance.insert(colMap);
    assertEquals(1, result);
    
    String cmd = con.getTestCalls();
    System.out.println("cmd" + cmd);
    assertEquals("INSERT INTO \P (ڂP,ڂQ,ڂR) VALUES ('2006-1-3','9928','1234')!", cmd);
  }

  /**
   *  caɐڑȂŁAnq}bsOupdateeXg
   */
  public void testUpdate() throws Exception {
    System.out.println("update");
    MockConnection con = new MockConnection();
    LinkedHashMap colMap = new LinkedHashMap();
    colMap.put("\P_ڂP", "2006-1-3");
    colMap.put("\P_ڂQ", "9928");
    colMap.put("\P_ڂR", "1234");
    
    MockMetaDataCache meta = new MockMetaDataCache();
    JlynxHibSession instance = new JlynxHibSession(con);
    instance.setMetaDataCache(meta);
    // eXgΏۃ\bhs
    int result = instance.update(colMap);
    assertEquals(1, result);
    
    String cmd = con.getTestCalls();
    System.out.println("cmd" + cmd);
    assertEquals("UPDATE \P SET ڂQ='9928', ڂR='1234' WHERE ڂP='2006-1-3'!", cmd);
  }

  /**
   *  caɐڑȂŁAnq}bsOupdateeXg
   */
  public void testUpdate2() throws Exception {
    System.out.println("update2");
    MockConnection con = new MockConnection();
    LinkedHashMap colMap = new LinkedHashMap();
    colMap.put("\P.ڂP", "2006-1-3");
    colMap.put("\P.ڂQ", "9928");
    colMap.put("\P.ڂR", "1234");
    
    MockMetaDataCache meta = new MockMetaDataCache();
    JlynxHibSession instance = new JlynxHibSession(con);
    instance.setSeparateCharacter(".");  // \ƍڂ̋؂蕶 .@ɕύX
    instance.setMetaDataCache(meta);
    // eXgΏۃ\bhs
    int result = instance.update(colMap);
    assertEquals(1, result);
    
    String cmd = con.getTestCalls();
    System.out.println("cmd" + cmd);
    assertEquals("UPDATE \P SET ڂQ='9928', ڂR='1234' WHERE ڂP='2006-1-3'!", cmd);
  }

  /**
   *  caɐڑȂŁAnq}bsOdeleteeXg
   */
  public void testDelete() throws Exception {
    System.out.println("delete");
    MockConnection con = new MockConnection();
    LinkedHashMap colMap = new LinkedHashMap();
    colMap.put("\P_ڂP", "2006-1-3");
    colMap.put("\P_ڂQ", "9928");
    colMap.put("\P_ڂR", "1234");
    
    MockMetaDataCache meta = new MockMetaDataCache();
    JlynxHibSession instance = new JlynxHibSession(con);
    instance.setMetaDataCache(meta);
    // eXgΏۃ\bhs
    int result = instance.delete(colMap);
    assertEquals(1, result);
    
    String cmd = con.getTestCalls();
    System.out.println("cmd" + cmd);
    assertEquals("DELETE FROM \P WHERE ڂP='2006-1-3'!", cmd);
  }
  /**
   *  caɐڑȂŁAnq}bsOdeleteeXg
   */
  public void testDelete2() throws Exception {
    System.out.println("delete2");
    MockConnection con = new MockConnection();
    LinkedHashMap colMap = new LinkedHashMap();
    colMap.put("\P.ڂP", "2006-1-3");
    colMap.put("\P.ڂQ", "9928");
    colMap.put("\P.ڂR", "1234");
    
    MockMetaDataCache meta = new MockMetaDataCache();
    JlynxHibSession instance = new JlynxHibSession(con);
    instance.setSeparateCharacter(".");  // \ƍڂ̋؂蕶 .@ɕύX
    instance.setMetaDataCache(meta);
    // eXgΏۃ\bhs
    int result = instance.delete(colMap);
    assertEquals(1, result);
    
    String cmd = con.getTestCalls();
    System.out.println("cmd" + cmd);
    assertEquals("DELETE FROM \P WHERE ڂP='2006-1-3'!", cmd);
  }
  /**
   *  caɐڑȂŁAnq}bsOselectByKeyeXg
   */
  public void testSelect() throws Exception {
    System.out.println("select");
    MockConnection con = new MockConnection();
    LinkedHashMap colMap = new LinkedHashMap();
    colMap.put("TBL1_aaa", "2006-1-3");
    colMap.put("TBL1_bbb", "9928");
    colMap.put("TBL1_ccc", "1234");
    
    MockMetaDataCache meta = new MockMetaDataCache();
    JlynxHibSession instance = new JlynxHibSession(con);
    instance.setMetaDataCache(meta);
    // eXgΏۃ\bhs
    Map result = instance.selectByKey(colMap);
  //  assertEquals(1, result);
    System.out.println("res " + result);
    
    String cmd = con.getTestCalls();
    System.out.println("cmd" + cmd);
    assertEquals("SELECT * FROM tbl1 WHERE aaa='2006-1-3'!", cmd);
  }
  /**
   *  caɐڑȂŁAnq}bsOselectByKeyeXg
   */
  public void testSelect2() throws Exception {
    System.out.println("select2");
    MockConnection con = new MockConnection();
    LinkedHashMap colMap = new LinkedHashMap();
    colMap.put("TBL1.aaa", "2006-1-3");
    colMap.put("TBL1.bbb", "9928");
    colMap.put("TBL1.ccc", "1234");
    
    MockMetaDataCache meta = new MockMetaDataCache();
    JlynxHibSession instance = new JlynxHibSession(con);
    instance.setSeparateCharacter(".");  // \ƍڂ̋؂蕶 .@ɕύX
    instance.setMetaDataCache(meta);
    // eXgΏۃ\bhs
    Map result = instance.selectByKey(colMap);
  //  assertEquals(1, result);
    System.out.println("res " + result);
    
    String cmd = con.getTestCalls();
    System.out.println("cmd" + cmd);
    assertEquals("SELECT * FROM tbl1 WHERE aaa='2006-1-3'!", cmd);
  }
}
