/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.facelet;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.*;
import com.sun.facelets.tag.jsf.html.AbstractHtmlLibrary;
/**
 * 
 */
public final class TagLibrary extends AbstractHtmlLibrary {

  protected final static Logger log = Logger.getLogger("strawberry.database.TagLibrary");

  // 2007.1.26
  public final static String Namespace = "http://www.ne.jp/asahi/java/servlet/database";

  public final static TagLibrary Instance = new TagLibrary();

  public TagLibrary() {
    super(Namespace);

    this.addTagHandler("query", QueryHandler.class);

    // onLoadƂO͎gȂlqȂ̂ŁA initOnLoadɖ̕ύX

    this.addHtmlComponent("initOnLoad",
                          "dwarf.facelet.OnLoad", "dwarf.facelet.OnLoad");

    //  o[WAbv
    

    // addHtmlComponent(String name, String componentType, String rendererType)
    this.addHtmlComponent("columnName",
                          "dwarf.jsf.component.UIColumnName", "dwarf.jsf.component.UIColumnName");

    this.addHtmlComponent("description",
                          "dwarf.jsf.component.UIDescription", "dwarf.jsf.component.UIDescription");

    this.addHtmlComponent("selectDataWhenAfterRestoreView",
                          "dwarf.facelet.SelectDataWhenAfterRestoreView", "dwarf.facelet.SelectDataWhenAfterRestoreView");

    // 2007.6.29
    this.addHtmlComponent("selectDataWhenAfterUpdateModelValues",
                          "dwarf.facelet.SelectDataWhenAfterUpdateModelValues", "dwarf.facelet.SelectDataWhenAfterUpdateModelValues");

    
    this.addHtmlComponent("initNewFormWhenAfterRestoreView",
                          "dwarf.facelet.InitNewForm", "dwarf.facelet.InitNewForm");

    this.addHtmlComponent("commandButton",
                          "dwarf.component.OrmCommandButton", "dwarf.component.OrmCommandButton");

    
    this.addHtmlComponent("redirectIfNull",
                          "dwarf.facelet.RedirectIfNull", "dwarf.facelet.RedirectIfNull");

    this.addHtmlComponent("checkIfNull",
                          "dwarf.facelet.CheckIfNull", "dwarf.facelet.CheckIfNull");


    // 2007.4.16
    this.addHtmlComponent("inputText",
                          "strawberry.HtmlInputText", "strawberry.HtmlInputText");

    this.addHtmlComponent("outputText",
                          "strawberry.HtmlOutputText", "strawberry.HtmlOutputText");
    
    // ) strawberry.config.ApplicationInitializer
    //           configureComponentsɂo^Kv

    this.addConverter("convertColumnType", "DateTimeConverter.CONVERTER_ID", ConvertColumnTypeHandler.class);

    this.addHtmlComponent("listViewPanel",
                          "dwarf.component.ListViewPanel", "dwarf.component.ListViewPanel");

 //   this.addValidator("validateRedirect", RedirectValidator.VALIDATOR_ID);

    
    try {
      Method[] methods = DwarfFunctions.class.getMethods();
      for (int i = 0; i < methods.length; i++) {
        if (Modifier.isStatic(methods[i].getModifiers())) {
          
          if (log.isLoggable(Level.FINER)) log.finer("add function " +  methods[i].getName());

          fns.put(methods[i].getName(), methods[i]);
        }
      }
    } catch (Exception e) {
      log.log(Level.SEVERE, "103) catch Exception", e);
      throw new RuntimeException(e);
    }
     
  }

  
  private final Map fns = new HashMap();

  public boolean containsFunction(String ns, String name) {
    if (Namespace.equals(ns)) {
      return this.fns.containsKey(name);
    }
    return false;
  }

  public Method createFunction(String ns, String name) {
    if (Namespace.equals(ns)) {
      return (Method) this.fns.get(name);
    }
    return null;
  }
}
