/*
 * Copyright (C) 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.facelet;

import dwarf.hiberlike.HibSession;
import dwarf.hiberlike.HibSessionFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.*;
import javax.faces.component.*;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import strawberry.lifecycle.AfterUpdateModelValues;
/**
 *  AfterUpdateModelValuestF[YŁAf[^x[Xf[^܂B
 *  ̃R|[lg͎ȃ_OȂ̂ŁAΉ郌_[͂܂B
 *
 *  Created on 2007/06/29
 */
public class SelectDataWhenAfterUpdateModelValues extends UIComponentBase implements AfterUpdateModelValues {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.database");
  
  /** Cxg󂯎郁\bh */
  public void afterUpdateModelValues(FacesContext context) {

    RuntimeException exp = null;
    log.config("start select data from RDB ");
    try {
      _afterUpdateModelValues(context);
    } catch (RuntimeException re) {
      exp = re;
    }

    log.config("end select data from RDB ");
    if (exp != null) throw exp;
  }
  
  public void _afterUpdateModelValues(FacesContext context) {
    HibSessionFactory hibSessionFact = FactoryUtil.findHibSessionFactory(context);
    if (hibSessionFact == null) {
      log.warning("hibSessionFactoryw肳Ă܂B");
      return;
    }
    log.fine("hibSessionFactory = " + hibSessionFact + "-----------------");

    
    Map input = context.getExternalContext().getRequestParameterMap();

    Map atts =  getAttributes();
    String mapName = (String) atts.get("targetMap");
    if (mapName == null) throw new NullPointerException();
    Map param = FactoryUtil.findTargetMap( context, mapName);
    /*
    Iterator it = attrs.keySet().iterator();
    while (it.hasNext()) {
      String key = (String) it.next();
      
      if (key.startsWith("com.sun.")) {
        log.finer("key = " + key + " ... ܂");
      } else {
        String value = (String) attrs.get(key);
        log.finer("key = " + key + ", value = " + value);

        String inp = (String) input.get(value);
        param.put(key, inp);
      }
    }*/
    log.fine("p = " + param);

//    HibSession hibSession = hibSessionFact.openSession();      \_ږ
    HibSession hibSession = hibSessionFact.getSession();    //   \.ږ
    Map result = null;
    try {
      result = hibSession.selectByKey(param);
    } catch (RuntimeException re) {
      log.severe("68) catch RuntimeException " + re.getMessage());
      throw re;
    } finally {
      log.fine("71) close()");
      hibSession.close();
    }
    log.fine("query result = " + result);

    if (result == null) {
      log.config("Return because query result is null" );
      return;
    }
    
    String targetName = getTargetMap();
    Map setTo = FactoryUtil.findTargetMap(context, targetName);
    log.finer("83) targetMap = " + setTo);
  
    if (setTo != null) {
      try {
        setTo.putAll(result);
        log.finer("88) targetMap = " + setTo);
      } catch (RuntimeException putEx) {
        log.severe("90) catch Exception = " + putEx.toString());
        // resultnull܂HashMap
        // setToHashtable̎AHashtablenullȂ̂ŁA
        // NullPointerException
        throw putEx;
      }
      context.renderResponse();
    }
  }

  String targetMap = null;

  public String getTargetMap() {
    if (null != this.targetMap) {
      return this.targetMap;
    }
    ValueBinding _vb = getValueBinding("targetMap");
    if (_vb != null) {
      log.fine("getValueBinding(targetMap)Ԃ܂");
      return (String) _vb.getValue(getFacesContext());
    } else {
      return null;
    }
  }

  public void setTargetMap(String x) {
    targetMap = x;
  }

  private String rendererType = null;

  public String getRendererType() {

    return (this.rendererType);
  }


  public void setRendererType(String x) {

    this.rendererType = x;
  }
  public String getFamily() {
    return "dwarf";
  }

  // Ȃpostɂ̂ŁAǉ
  public void decode(FacesContext context) {
  }
  
  public void encodeBegin(FacesContext context) throws IOException {
  }
  
  public void encodeChildren(FacesContext context) throws IOException {
  }

  public void encodeEnd(FacesContext context) throws IOException {
  }
}
