/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.facelet;

import java.util.logging.*;
import javax.faces.context.FacesContext;
import javax.faces.context.ExternalContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import strawberry.FaceletsConstants;
import strawberry.plugin.ScriptEngine;
/**
 * Created on 2007/05/15
 */
public class ScriptMethod extends MethodBinding {
  
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.tag.ScriptMethod");
  /** RXgN^ */
  public ScriptMethod() {
  }

  String script = null;
  /** RXgN^ */
  public ScriptMethod(String script) {
    this.script = script;
  }
  
  
  public Class getType(FacesContext facesContext) throws MethodNotFoundException {
    throw new UnsupportedOperationException();
  }

  public Object invoke(FacesContext facesContext, Object[] object) throws EvaluationException, MethodNotFoundException {
    log.info("invoke ---- ");
    log.info("script = " + script);

    ExternalContext ec = facesContext.getExternalContext();
    
    Object wk = ec.getApplicationMap().get(FaceletsConstants.ENGINE_KEY);
    
    ScriptEngine engine = (ScriptEngine) wk;
    Object ans = engine.evaluateString( script, "<dwarf.facelet.ScriptMethod>", 1);


    return "";
  }
  
}
