/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.facelet;

import dwarf.hiberlike.HibSession;
import dwarf.hiberlike.HibSessionFactory;
import dwarf.sql.Relation;
import dwarf.sql.HColumn;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.List;
import javax.faces.component.*;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import strawberry.lifecycle.AfterRestoreView;
import java.util.logging.*;
/**
 *  AfterRestoreViewtF[YŁAVK̓tH[쐬邽߂ɁA
 *  w肳ꂽMap܂
 *  ̃R|[lg͎ȃ_OȂ̂ŁAΉ郌_[͂܂B
 *  Created on 2007/03/09
 */
public class InitNewForm extends UIComponentBase implements AfterRestoreView {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.database");
  
  public String getFamily() {
    return "dwarf";
  }
  
  /** Cxg󂯎郁\bh */
  public void afterRestoreView(FacesContext context) {
  
      HibSessionFactory hibSessionFact = FactoryUtil.findHibSessionFactory(context);
    if (hibSessionFact == null) {
      log.warning("hibSessionFactoryw肳Ă܂B");
      return;
    }
    log.fine("hibSessionFactory = " + hibSessionFact + "-----------------");

    String tableName = getTableName();
    log.fine("tableName = '" + tableName + "'");

    
//    HibSession hibSession = hibSessionFact.openSession();      \_ږ
    HibSession hibSession = hibSessionFact.getSession();      //   \.ږ
    List result = null;
    try {
      Relation relation = new Relation(tableName);
      //result = hibSession.getMetaDataList(relation);
      result = hibSession.createListForNew(relation);
    } finally {
      hibSession.close();
    }

    if (result == null) {
      log.warning(" = nullȂ̂Ń^[" );
      return;
    }
    
    String targetMapName = getTargetMap();
    Map setTo = FactoryUtil.findTargetMap(context, targetMapName);
    if (setTo == null) {
      log.warning("setTo = nullȂ̂Ń^[" );
      return;
    }

    for (int i = 0; i < result.size(); i++) {
      HColumn hcol = (HColumn) result.get(i);

//    String key = hcol.getTableName() + "_" + hcol.getColumnName();
      String key = hcol.getTableName() + "." + hcol.getColumnName();
      setTo.put(key, "");
    }
  }

  String targetMap = null;

  public String getTargetMap() {
    if (null != this.targetMap) {
      return this.targetMap;
    }
    ValueBinding _vb = getValueBinding("targetMap");
    if (_vb != null) {
      log.fine("getValueBinding(targetMap)Ԃ܂");
      return (String) _vb.getValue(getFacesContext());
    } else {
      return null;
    }
  }


  String tableName = null;

  public String getTableName() {
    if (null != this.tableName) {
      return this.tableName;
    }
    ValueBinding _vb = getValueBinding("tableName");
    if (_vb != null) {
      log.fine("getValueBinding(tableName)Ԃ܂");
      return (String) _vb.getValue(getFacesContext());
    } else {
      return null;
    }
  }

  public void setTableName(String newValue) {
    log.info("setTableName ---- Ă΂܂");
    tableName = newValue;
  }
  
  public void encodeChildren(FacesContext context) throws IOException {
  }

  public void encodeBegin(FacesContext context) throws IOException {
  }

  private String rendererType =   null;

  public String getRendererType() {

    return (this.rendererType);
  }

  public void setRendererType(String x) {
    log.warning("setRendererType ---- ENTER");
    //this.rendererType = x;
  }
  // Ȃpostɂ
  public void decode(FacesContext context) {
  }
  
  public void encodeEnd(FacesContext context) throws IOException {
  }
}
