package dwarf.facelet;

import dwarf.convert.ColumnTypeConverter;
import java.util.TimeZone;

import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.jsf.ComponentSupport;
import com.sun.facelets.tag.jsf.ConvertHandler;
import com.sun.facelets.tag.jsf.ConverterConfig;
import java.util.logging.*;

/**
 * HColumñ^CvɉRo[gBƂ肠Oracle͖B
 * Created on 2007/03/11
 */
public final class ConvertColumnTypeHandler extends ConvertHandler {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.tag");

  private final TagAttribute dataType;

  /**
   * @param config
   */
  public ConvertColumnTypeHandler(ConverterConfig config) {
    super(config);

    this.dataType = this.getAttribute("dataType");
  }

  /**
   * Returns a new DateTimeConverter
   *
   * @see com.sun.facelets.tag.jsf.ConvertHandler#createConverter(com.sun.facelets.FaceletContext)
   */
  protected Converter createConverter(FaceletContext ctx) throws FacesException, ELException, FaceletException {

    //log.info("createConverter  ------------- ");
    return ctx.getFacesContext().getApplication().createConverter(ColumnTypeConverter.CONVERTER_ID);
  }

  /**
   * Implements tag spec, see taglib documentation.
   *
   * @see com.sun.facelets.tag.ObjectHandler#setAttributes(com.sun.facelets.FaceletContext,
   *      java.lang.Object)
   */
  protected void setAttributes(FaceletContext ctx, Object obj) {

    if (log.isLoggable(Level.FINER)) {
      log.finer("setAttributes  " + obj + "  ------------- ");
    }
    
    ColumnTypeConverter c = (ColumnTypeConverter) obj;
    if (this.dataType != null) {

      // dataType  com.sun.facelets.tag.TagAttribute

      //Object val = this.dataType.getValue(ctx);
      //                        getValue͕KŋAĂ̂Ń_
      
      Object val = this.dataType.getObject(ctx, Object.class);
      
      log.fine("(73) value = " + val.getClass().getName());

      c.setDataType(val);
    }
  }

  protected MetaRuleset createMetaRuleset(Class type) {

    log.info("createMetaRuleset  " + type + "  ------------- ");
    return super.createMetaRuleset(type).ignoreAll();
  }
}
