/*  -*- Mode: java4; -*-
 
 TopMind jLynx "jLynx JDBC Framework"
 Copyright (c) 2004-2006. TopMind Systems Inc.
 All rights reserved.
 
 This file is part of TopMind jLynx.
 
 TopMind jLynx is free software; you can redistribute it and/or modify
 it under the terms of the License. See website for License.
 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 */
package mod.sf.jlynx;

import java.util.StringTokenizer;

/**
 * Utility class used internally by jLynx
 *
 * $Revision: 51 $
 * $Date: 2006-10-10 13:32:47 -0400 (Tue, 10 Oct 2006) $
 *
 */
final class StringUtils {

    protected static String capitalize(String str) {
        return capitalize(str, true);
    }

    static String replace(String source, String pattern, String replace) {
        if (source!=null) {
            final int len = pattern.length();
            StringBuffer sb = new StringBuffer();
            int found = -1;
            int start = 0;

            while( (found = source.indexOf(pattern, start) ) != -1) {
                sb.append(source.substring(start, found));
                sb.append(replace);
                start = found + len;
            }

            sb.append(source.substring(start));

            return sb.toString();
        } else return "";
    }

    protected static String capitalize(String str, boolean simpleMode) {

        if (str == null) {
            return null;
        } else if (simpleMode) {
            return Character.toUpperCase(str.charAt(0)) + str.substring(1);
        }
        StringTokenizer st = new StringTokenizer(str, "_");
        String result = "";
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            result += Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }

        return result;

    }

    protected static String createAccessor(String field, String type) {

        if (field == null || type == null) {
            return null;
        } else {
            field = field.toLowerCase();
            field = replace(field, " ", "");
            // jdk 1.3 issue .replaceAll(" ", "");
            return "\n" + get(field, type) + set(field, type);
        }

    }
/*
    protected static String escapeQuotes(String str) {

        if (str != null) {
            return replace(str, "'", "''");
            // jdk 1.3 issue str.replaceAll("'", "''");
        } else {
            return null;
        }
    }*/

    // postgres jdbchCo݊
    public static String escapeQuotes(String x) {

        if (x == null) return null;
        
        StringBuffer sbuf = new StringBuffer();

        for (int i = 0 ; i < x.length() ; ++i) {
            char c = x.charAt(i);
            if (c == '\\' || c == '\'')
                sbuf.append((char)'\\');
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    private static String get(String field, String type) {

        if (field == null || type == null) {
            return null;
        } else {

            field = field.toLowerCase();
            field = replace(field, " ", "");
            // jdk 1.3 issue .replaceAll(" ", "");
            return "\n\tpublic " + type + " get" + capitalize(field)
                + "() {\n\t\treturn " + field + ";\n\t}";
        }

    }

    private static String set(String field, String type) {

        if (field == null) {
            return null;
        } else {
            field = field.toLowerCase();
            field = replace(field, " ", "");
            // jdk 1.3 issue .replaceAll(" ", "");
            return "\n\n\tpublic void set" + capitalize(field) + "(" + type
                + " in) {\n\t\tthis." + field + " = in;\n\t}\n";
        }

    }

}