/*
 * Copyright (C) 2007 Masahito Henmi, All rights reserved.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.ext;

import dwarf.hiberlike.HiberlikeException;
import dwarf.hiberlike.HibSession;
import dwarf.hiberlike.HibSessionFactory;
import dwarf.sql.MetaDataCache;
import java.sql.Connection;
import javax.sql.DataSource;

import java.util.logging.*;
/**
 *  implementation of the <tt>SessionFactory</tt> interface.
 */
public class JlynxMultiSessionFactory implements HibSessionFactory {
    
    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.JlynxMultiSessionFactory");
    
    static final long serialVersionUID = 6820231656420970208L;
    
    private   transient DataSource dataSource = null;
    
    public void setDataSource(DataSource ds) {
        dataSource = ds;
    }
    
    transient  MetaDataCache metadataCache = null;
    
    /** RXgN^ */
    public JlynxMultiSessionFactory() throws HiberlikeException {
    }
    
    public void setMetaDataCache(Object obj) {
        MetaDataCache mc = (MetaDataCache ) obj;
        log.info("#setMetadataCache ------ ܂ " + mc);
        metadataCache = mc;
    }
    
    public void setCacheObject(Object obj) {
        metadataCache = (MetaDataCache) obj;
    }
    
    public String toString() {
        return "JlynxMultiSessionFactory[" + metadataCache + "]";
    }
    
    
    /** ʏ킱g */
    public HibSession openSession() throws HiberlikeException {
        
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
        } catch (Exception ex) {
            throw new RuntimeException();
        }
        JlynxMultiSession instance = new JlynxMultiSession(conn);
        
        instance.setMetaDataCache(metadataCache); //////////
        return instance;
    }
    
    /**
     *  Connection鎞ɁAConnection SessionB
     *  ŁAꂽHibSessioncloseȂǂB
     *  connectionŁAconnectionclosêǂ
     */
    public HibSession createSession(Connection con) {
        
        JlynxMultiSession instance = new JlynxMultiSession(con);
        
        return instance;
    }
    
    public HibSession getSession(Connection connection) {
        throw new UnsupportedOperationException();
    }
    
    public HibSession getSession() {
        throw new UnsupportedOperationException();
    }
}
