/*
 * Copyright (C) 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.ext;

import dwarf.hiberlike.HibDuplicateKeyException;
import dwarf.hiberlike.HibNotNullConstraintException;
import dwarf.hiberlike.HibSession;
import dwarf.hiberlike.HiberlikeException;
import dwarf.sql.MetaData;
import dwarf.sql.MetaDataCache;
import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.*;

import mod.sf.jlynx.RelationalEx;
/**
 *  JlynxHibSession ̕\AΉ
 *  ۑFExceptionΐApostgresɈˑĂ܂B
 *  Created on 2007/06/04,
 */
public class JlynxMultiSession implements HibSession {
  
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.jlynx.JlynxMultiSession");

  MetaDataCache mCache = null;
  Connection con = null;
  /** RXgN^ */
  public JlynxMultiSession(Connection con) {
    this.con = con;
  }
  public void setMetaDataCache(MetaDataCache newValue) {
    mCache = newValue;
  }
  
  public int insert(Map object) {
    log.fine("insert(Map x) --------------܂");
    
    MultipleTableSupport mts = new MultipleTableSupport();
    Map tables = mts.processTables(object);
    
    int n = 0;
    try {
      try {
        con.setAutoCommit(false);
        Iterator it = tables.keySet().iterator();
        while (it.hasNext()) {
          String tblName = (String) it.next();
          Map col_data = (Map) tables.get(tblName);
          
          RelationalEx jlynx = new RelationalEx(tblName);
          jlynx.setConnection(con);
          jlynx.setObject(col_data);
          n = jlynx.insert();
        }
        con.commit();
      } catch (Exception ex) {
        con.rollback();
        throw ex;
      }
    } catch (Exception ex) {
      String msg = ex.getMessage();
      // ExceptionϊBpostgresˑłB
      if (msg != null && msg.indexOf("duplicate key") >= 0) {
        throw new HibDuplicateKeyException("L[d", ex);
      } else if (msg != null && msg.indexOf("violates not-null constraint") >= 0) {
        throw new HibNotNullConstraintException("not null ", ex);
      } else {
        throw new HiberlikeException(ex);
      }
    }
    return n;
  }
  public String[] getKeyFieldsArrayFromMetaDataCache(String tblName) {

    log.fine("^f[^܂");
    MetaData meta = mCache.getMetaData(/*null,*/ tblName);

    if (meta == null) {
        log.severe("555) '" + tblName + "' ܂");
    }
    return meta.getKeyList();
  }
  
  public int delete(Map model) {
    log.fine("delete(Map x) --------------܂");
    
    MultipleTableSupport mts = new MultipleTableSupport();
    Map tables = mts.processTables(model);
    
    int n = 0;
    try {
      try {
        con.setAutoCommit(false);
        Iterator it = tables.keySet().iterator();
        while (it.hasNext()) {
          String tblName = (String) it.next();
          log.fine("\:" + tblName);
          Map col_data = (Map) tables.get(tblName);
          
          RelationalEx jlynx = new RelationalEx(tblName);
          jlynx.setConnection(con);
          jlynx.setKeyFields(getKeyFieldsArrayFromMetaDataCache(tblName));
          jlynx.setObject(col_data);
          n = jlynx.delete();
        }
        con.commit();
      } catch (Exception ex) {
        con.rollback();
        throw ex;
      }
    } catch (Exception ex) {
      String msg = ex.getMessage();
      // ExceptionϊBpostgresˑłB
      if (msg != null && msg.indexOf("duplicate key") >= 0) {
        throw new HibDuplicateKeyException("L[d", ex);
      } else if (msg != null && msg.indexOf("violates not-null constraint") >= 0) {
        throw new HibNotNullConstraintException("not null ", ex);
      } else {
        throw new HiberlikeException(ex);
      }
    }
    return n;
  }
  public int update(Map model) {
    log.fine("update(Map x) --------------܂");
    
    MultipleTableSupport mts = new MultipleTableSupport();
    Map tables = mts.processTables(model);
    
    int n = 0;
    try {
      try {
        con.setAutoCommit(false);
        Iterator it = tables.keySet().iterator();
        while (it.hasNext()) {
          String tblName = (String) it.next();
          log.fine("\:" + tblName);
          Map col_data = (Map) tables.get(tblName);
          
          RelationalEx jlynx = new RelationalEx(tblName);
          jlynx.setConnection(con);
          jlynx.setKeyFields(getKeyFieldsArrayFromMetaDataCache(tblName));
          jlynx.setObject(col_data);
          n = jlynx.update();
        }
        con.commit();
      } catch (Exception ex) {
        con.rollback();
        throw ex;
      }
    } catch (Exception ex) {
      String msg = ex.getMessage();
      // ExceptionϊBpostgresˑłB
      if (msg != null && msg.indexOf("duplicate key") >= 0) {
        throw new HibDuplicateKeyException("L[d", ex);
      } else if (msg != null && msg.indexOf("violates not-null constraint") >= 0) {
        throw new HibNotNullConstraintException("not null ", ex);
      } else {
        throw new HiberlikeException(ex);
      }
    }
    return n;
  }
  // b: JlynxHibSessionMaṕAႤ
  public void updateOrInsert(Map model) {
    log.info("updateOrInsert --------------܂");
    
    try {
      update(model);
    } catch (HiberlikeException he) {
      insert(model);
    }
  }
  //-----------------------------------------------------------------
  public List selectByKey(Map relation, List keyValues) {
    throw new UnsupportedOperationException();
  }
  
  
  public Map selectByKey(Map keyValues) {
    throw new UnsupportedOperationException();
  }
  
  public List createListForNew(Map relation) {
    throw new UnsupportedOperationException();
  }
  
  
  public void setValue(List list, int i, Object obj) {
    throw new UnsupportedOperationException();
  }
  
  public void updateOrInsert(List list) {
    throw new UnsupportedOperationException();
  }
  
  public int update(List list) {
    throw new UnsupportedOperationException();
  }
  
  public int delete(List list) {
    throw new UnsupportedOperationException();
  }
  
  
  public int insert(List list) {
    throw new UnsupportedOperationException();
  }
  
  
  public void close() {
    try {
      con.close();
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
  }
  
  public List createListForEdit(Map relation, Map requestMap) {
    throw new UnsupportedOperationException();
  }
  
  public Object[] dbaShowList(Map relation, Map parameter) {
    throw new UnsupportedOperationException();
  }
  
  
}
