/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.sqlmock;

import java.math.BigDecimal;
import java.sql.*;
import java.util.*;
import java.util.logging.*;
/**
 *
 */
public class MockResultSetList extends MockResultSet {
  
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.sql");

  List list = null;

  /** RXgN^ */
  public MockResultSetList() {
    list = new ArrayList();
  }

  /** RXgN^ */
  public MockResultSetList(List list) {
    this.list = list;
  }

  int row = -1;

  public boolean next() throws SQLException {
      row++;
      return  row < list.size();
  }

  ResultSetMetaData metaData = null;
  
  public ResultSetMetaData getMetaData() throws SQLException {

    if (metaData == null) {
       metaData = new MockResultSetMetaData();
    }
    return metaData;
  }

  
  public String getString(int columnIndex) throws SQLException {
    log.info(idText + "getString(i) ܂" + columnIndex);
    return (String) getObject(columnIndex);
  }

  public String getString(String columnName) throws SQLException {

    log.info(idText + "getString ܂" + columnName);
    int n = findColumn(columnName);
    return getString(n);
  }
  
  public java.sql.Date getDate(int columnIndex) throws SQLException {

    log.info(idText + "getDate(i) ܂" + columnIndex);
    return (java.sql.Date) getObject(columnIndex);
  }

  public Time getTime(int columnIndex) throws SQLException {
    return (Time) getObject(columnIndex);
  }
  

  public Timestamp getTimestamp(int columnIndex) throws SQLException {

    log.info(idText + "getTimestamp(i) ܂" + columnIndex);
    return (Timestamp) getObject(columnIndex);
  }
  
  
  public long getLong(int columnIndex) throws SQLException {
      Long lng = (Long) getObject(columnIndex);
    return lng.longValue();
  }

  public int getInt(int columnIndex) throws SQLException {
      Integer it = (Integer) getObject(columnIndex);
    return it.intValue();
  }

  public float getFloat(int columnIndex) throws SQLException {
      Float wk = (Float) getObject(columnIndex);
    return wk.floatValue();
  }

  public double getDouble(int columnIndex) throws SQLException {
      Double wk = (Double) getObject(columnIndex);
    return wk.doubleValue();
  }


  public long getLong(String columnName) throws SQLException {
    return getLong(findColumn(columnName));
  }

  public int getInt(String columnName) throws SQLException {

    log.info(idText + "getInt ܂" + columnName);
    return getInt(findColumn(columnName));
  }

  public float getFloat(String columnName) throws SQLException {
    return getFloat(findColumn(columnName));
  }

  public double getDouble(String columnName) throws SQLException {
    return getDouble(findColumn(columnName));
  }

  public java.sql.Date getDate(String columnName) throws SQLException {
    return getDate(findColumn(columnName));
  }

  public BigDecimal getBigDecimal(String columnName) throws SQLException {
    return getBigDecimal(findColumn(columnName));
  }

  public boolean getBoolean(String columnName) throws SQLException {
    return getBoolean(findColumn(columnName));
  }

  public byte getByte(String columnName) throws SQLException {
    return getByte(findColumn(columnName));
  }

  public Object getObject(String columnName) throws SQLException {
    return getObject(findColumn(columnName));
  }

  public short getShort(String columnName) throws SQLException {
    return getShort(findColumn(columnName));
  }

  public Time getTime(String columnName) throws SQLException {
    return getTime(findColumn(columnName));
  }

  public Timestamp getTimestamp(String columnName) throws SQLException {
    return getTimestamp(findColumn(columnName));
  }

  public Object getObject(int columnIndex) throws SQLException {
      Object obj = list.get(row);
      if (obj instanceof Map) {
          Map map = (Map) obj;
          throw new UnsupportedOperationException();
      } else if (obj instanceof List) {
          List lt = (List) obj;
          return lt.get(columnIndex -1);
      } else {
          throw new UnsupportedOperationException();
      }
  }

  public boolean absolute(int row) throws SQLException {
          throw new UnsupportedOperationException();
  }

  public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
    return null;
  }


  public boolean getBoolean(int columnIndex) throws SQLException {
    return false;
  }

  public byte getByte(int columnIndex) throws SQLException {
    return 0;
  }


  public short getShort(int columnIndex) throws SQLException {
    return 0;
  }




  public boolean wasNull() throws SQLException {
    return false;
  }

  
}
