/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.sqlmock;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.*;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.*;
/**
 *
 */
public class MockResultSet implements ResultSet {
  
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.sql");
  /** RXgN^ */
  public MockResultSet() {
  }

  String idText = "???? ";
  
  public MockResultSet setMemo(String x) {
    idText = x + " ";
    return this;
  }


  
  boolean nextFlag = true;

  // ̂ true Ԃ
  public boolean next() throws SQLException {
    boolean wk = nextFlag;
    nextFlag = false;
    return wk;
  }
  public ResultSetMetaData getMetaData() throws SQLException {
    return new MockResultSetMetaData();
  }

  String getStringValue = null;
  
  public void setString(String x) {
    getStringValue = x;
  }
  
  public String getString(int columnIndex) throws SQLException {
    log.info(idText + "getString(i) ܂" + columnIndex);
    return getStringValue;
  }

  public String getString(String columnName) throws SQLException {

    log.info(idText + "getString ܂" + columnName);

    String ans = null;
    
    if ("COLUMN_NAME".equals(columnName)) {
      ans = "col1";
    } else {
      ans = columnName;
    }
    
    log.info("getString ==> " + ans);
    
    return ans;
  }

  java.sql.Date getDateValue = null;
  
  public void setDate(java.sql.Date x) {
    getDateValue = x;
  }
  
  public java.sql.Date getDate(int columnIndex) throws SQLException {

    log.info(idText + "getDate(i) ܂" + columnIndex);
    return getDateValue;
  }


  public Time getTime(int columnIndex) throws SQLException {
    return null;
  }
  
  Timestamp getTimestampValue = null;
  
  public void setTimestamp(Timestamp x) {
    getTimestampValue = x;
  }

  public Timestamp getTimestamp(int columnIndex) throws SQLException {

    log.info(idText + "getTimestamp(i) ܂" + columnIndex);
    return getTimestampValue;
  }
  
  
  public long getLong(int columnIndex) throws SQLException {
    return 0;
  }

  public int getInt(int columnIndex) throws SQLException {
    return 0;
  }

  public float getFloat(int columnIndex) throws SQLException {
    return 0;
  }

  public double getDouble(int columnIndex) throws SQLException {
    return 0;
  }

  
  public Object getObject(String str, Map map) {
    throw new UnsupportedOperationException();
  }
  public Object getObject(int n , Map map) {
    throw new UnsupportedOperationException();
  }
  public void updateFloat(String columnName, float x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public java.sql.Date getDate(int columnIndex, Calendar cal) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Time getTime(int columnIndex, Calendar cal) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
    throw new UnsupportedOperationException();
  }

 // public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
 // }

  public void updateDate(String columnName, java.sql.Date x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void updateShort(int columnIndex, short x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void updateBlob(String columnName, Blob x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void updateArray(String columnName, Array x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void updateDouble(int columnIndex, double x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void updateFloat(int columnIndex, float x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void updateTime(int columnIndex, Time x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public java.sql.Date getDate(String columnName, Calendar cal) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Time getTime(String columnName, Calendar cal) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void updateDouble(String columnName, double x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void updateNull(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public long getLong(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public int getInt(String columnName) throws SQLException {

    log.info(idText + "getInt ܂" + columnName);

    return 99;
  }

  public float getFloat(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public double getDouble(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public java.sql.Date getDate(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Clob getClob(String colName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Reader getCharacterStream(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public byte[] getBytes(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public InputStream getAsciiStream(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Array getArray(String colName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public int findColumn(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public BigDecimal getBigDecimal(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public InputStream getBinaryStream(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Blob getBlob(String colName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public boolean getBoolean(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public byte getByte(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Object getObject(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Ref getRef(String colName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public short getShort(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }


  public Time getTime(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Timestamp getTimestamp(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public URL getURL(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public InputStream getUnicodeStream(String columnName) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void updateBytes(String columnName, byte[] x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void updateRef(String columnName, Ref x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void updateNull(int columnIndex) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Object getObject(int columnIndex) throws SQLException {
    throw new UnsupportedOperationException();
  }


  public Clob getClob(int i) throws SQLException {
    return null;
  }

  public Reader getCharacterStream(int columnIndex) throws SQLException {
    return null;
  }

  public byte[] getBytes(int columnIndex) throws SQLException {
    return null;
  }

  public InputStream getAsciiStream(int columnIndex) throws SQLException {
    return null;
  }

  public Array getArray(int i) throws SQLException {
    return null;
  }

  public boolean absolute(int row) throws SQLException {
    return false;
  }

  public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
    return null;
  }

  public InputStream getBinaryStream(int columnIndex) throws SQLException {
    return null;
  }

  public Blob getBlob(int i) throws SQLException {
    return null;
  }

  public boolean getBoolean(int columnIndex) throws SQLException {
    return false;
  }

  public byte getByte(int columnIndex) throws SQLException {
    return 0;
  }

  public Ref getRef(int i) throws SQLException {
    return null;
  }

  public short getShort(int columnIndex) throws SQLException {
    return 0;
  }


  public URL getURL(int columnIndex) throws SQLException {
    return null;
  }

  public InputStream getUnicodeStream(int columnIndex) throws SQLException {
    return null;
  }

  public boolean relative(int rows) throws SQLException {
    return false;
  }

  public void setFetchDirection(int direction) throws SQLException {
  }

  public void setFetchSize(int rows) throws SQLException {
  }

  public void updateBoolean(String columnName, boolean x) throws SQLException {
  }

  public void updateObject(String columnName, Object x) throws SQLException {
  }

  public void updateDate(int columnIndex, java.sql.Date x) throws SQLException {
  }

  public void updateClob(String columnName, Clob x) throws SQLException {
  }

  public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
  }

  public void updateByte(String columnName, byte x) throws SQLException {
  }

  public void updateShort(String columnName, short x) throws SQLException {
  }

  public void updateLong(String columnName, long x) throws SQLException {
  }


  public void updateRef(int columnIndex, Ref x) throws SQLException {
  }

  public void updateArray(int columnIndex, Array x) throws SQLException {
  }

  public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
  }

  public void updateClob(int columnIndex, Clob x) throws SQLException {
  }

  public void updateLong(int columnIndex, long x) throws SQLException {
  }

  public void updateBytes(int columnIndex, byte[] x) throws SQLException {
  }

  public void updateByte(int columnIndex, byte x) throws SQLException {
  }

  public void updateTime(String columnName, Time x) throws SQLException {
  }

  public void updateBlob(int columnIndex, Blob x) throws SQLException {
  }

  public void updateString(int columnIndex, String x) throws SQLException {
  }

  public void updateObject(String columnName, Object x, int scale) throws SQLException {
  }

  public void updateObject(int columnIndex, Object x) throws SQLException {
  }

  public void updateInt(String columnName, int x) throws SQLException {
  }

  public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
  }

  public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
  }

//  @Deprecated
  public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
    return null;
  }

  public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
  }

  public void updateBoolean(int columnIndex, boolean x) throws SQLException {
  }

  public boolean wasNull() throws SQLException {
    return false;
  }

  public void updateString(String columnName, String x) throws SQLException {
  }

  public void updateRow() throws SQLException {
  }

  public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
  }

  public void updateInt(int columnIndex, int x) throws SQLException {
  }

  public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
  }

  public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
  }


  public int getFetchSize() throws SQLException {
    return 0;
  }

  public int getFetchDirection() throws SQLException {
    return 0;
  }

  public String getCursorName() throws SQLException {
    return null;
  }

  public int getConcurrency() throws SQLException {
    return 0;
  }

  public boolean first() throws SQLException {
    return false;
  }

  public void deleteRow() throws SQLException {
  }

  public void close() throws SQLException {
  }

  public void clearWarnings() throws SQLException {
  }

  public void cancelRowUpdates() throws SQLException {
  }

  public void beforeFirst() throws SQLException {
  }

  public void afterLast() throws SQLException {
  }

 // @Deprecated
  public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
    return null;
  }

  public int getRow() throws SQLException {
    return 0;
  }

  public Statement getStatement() throws SQLException {
    return null;
  }

  public int getType() throws SQLException {
    return 0;
  }

  public SQLWarning getWarnings() throws SQLException {
    return null;
  }

  public void insertRow() throws SQLException {
  }

  public boolean isAfterLast() throws SQLException {
    return false;
  }

  public boolean isBeforeFirst() throws SQLException {
    return false;
  }

  public boolean isFirst() throws SQLException {
    return false;
  }

  public boolean isLast() throws SQLException {
    return false;
  }

  public boolean last() throws SQLException {
    return false;
  }

  public void moveToCurrentRow() throws SQLException {
  }

  public void moveToInsertRow() throws SQLException {
  }



  public boolean previous() throws SQLException {
    return false;
  }

  public void refreshRow() throws SQLException {
  }

  public boolean rowDeleted() throws SQLException {
    return false;
  }

  public boolean rowInserted() throws SQLException {
    return false;
  }

  public boolean rowUpdated() throws SQLException {
    return false;
  }

  public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
  }
  
}
